/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.LinkedList;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;

/**
 *An editor and renderer for multi-selection.
 * @author Daniel Hakenjos
 * @version $Id: ListSelectEditor.java,v 1.3 2006/04/11 14:10:13 euler Exp $
 */
public class ListSelectEditor  extends SelectEditor implements ActionListener, ItemListener  {

	protected JComboBox box;
	
	protected String[] data;
	protected String[] selected_data;
	
    /**
     *Constructs a new <code>ListSelectEditor</code>.
     */
	public ListSelectEditor(MiningMartApplication app,Step step, OpParam opParam){
		super(app,step,opParam);
		data=new String[0];
		selected_data=new String[0];
		initComponents();
		init();
		setEditable();
	}

	private void initComponents(){
		JPanel panel=new JPanel(new BorderLayout());
		this.editorComponent=panel;
		setClickCountToStart(1);		

		box=new JComboBox();
		box.setBackground(Color.WHITE);
		box.setForeground(Color.BLACK);
		box.addItemListener(this);
		
		panel.add(box,BorderLayout.CENTER);
		
		button=new JButton("...");
		button.addActionListener(this);
		panel.add(button, BorderLayout.EAST);
		
	}
	
	public void init(){
		selected_data=new String[0];
		box.removeAllItems();
	}

    /**
     *Gets the value of the editor.
     */
	public Object getCellEditorValue() {
		String back="";
		for (int i=0;i<data.length;i++){
			if (i==0){
				back+=data[i];
			}else{
				back+=" "+data[i];
			}
		}
		return back;
	}


	/**
     * For your own selection you must overwrite this method.
     * Especially to construct the list.
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		String[] data=new String[]{"x","y","z","u","v","w","s","d","a","n","m","k","l"};		
		ListSelectDialog dialog=new ListSelectDialog(app,"title","selecttitle",data,selected_data,true,4,10);
		if (dialog.getExitAction()==ListSelectDialog.OK){
			selected_data=dialog.getSelectedDataItems();
			this.setDataItems(selected_data);
		}
	}

        /**
         *Gets the selected values.
         */
	public Collection getSelectedValues(){
		LinkedList list=new LinkedList();
		for (int d=0;d<selected_data.length;d++){
			list.add(selected_data[d]);
		}
		return list;
	}

	/**
	 * @see java.awt.event.ItemListener#itemStateChanged(ItemEvent)
	 */
	public void itemStateChanged(ItemEvent e) {
		if ((box.getSelectedIndex()!=0)&&(box.getItemCount()>0)){
			box.setSelectedIndex(0);
		}
	}

    /**
     *Sets the data items.
     */
	public void setDataItems(String[] items){
		box.removeAllItems();
		for(int i=0;i<items.length;i++){
			box.addItem(items[i]);
		}
	}
	
	public String[] getDataItems(){
		return selected_data;
	}
	
	
	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#setEditable()
	 */
	public void setEditable() {
		super.setEditable();
		box.setEditable(editable);
		button.setEnabled(editable);
	}

}
/*
$Log: ListSelectEditor.java,v $
Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:14  hakenjos
Initial version!

*/
