/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.stepsettings;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.OpParam;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 *An editor and renderer for multi-selection of <code>Concept</code>s.
 * @author Daniel Hakenjos
 * @version $Id: ListConceptEditor.java,v 1.3 2006/04/11 14:10:13 euler Exp $
 */
public class ListConceptEditor extends ListSelectEditor {

    /**
     *Constructs a new <code>ListConceptEditor</code>.
     */
	public ListConceptEditor(MiningMartApplication app,Step step, OpParam opParam){
		super(app,step,opParam);

	}
	
	
	public void init(){
		super.init();

		this.selected_data=new String[0];

		Collection coll=getParameterCollection();		
		if (coll!=null){
			this.selected_data=new String[coll.size()];
			Iterator iter=coll.iterator();
			int index=0;
			while (iter.hasNext()){
				if (opParam.isInput()){
					selected_data[index]=((Concept) iter.next()).getName();
				}else{
					selected_data[index]=(String) iter.next();
				}
				index++;
			}
		}
		setDataItems(selected_data);

	}
	
	

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		try{
//			Collection concepts=app.m4Interface.getCurrentCase().getConcepts();
			Collection concepts=step.getPossibleInputConcepts();
			this.data=new String[concepts.size()];
			
			Iterator iter=concepts.iterator();
			int c=0;
			while (iter.hasNext()){
				data[c]=((Concept) iter.next()).getName();
				c++;
			}
	
			ListSelectDialog dialog=new ListSelectDialog(app,Resource.getString("STEPSETTINGS_TITLE_CONCEPT"),Resource.getString("STEPSETTINGS_TITLE_SELECT_CONCEPT"),data,selected_data,true,opParam.getMinArg(),opParam.getMaxArg());
			if (dialog.getExitAction()==ListSelectDialog.OK){
				selected_data=dialog.getSelectedDataItems();
				this.setDataItems(selected_data);

				LinkedList list=new LinkedList();
				for(int s=0;s<selected_data.length;s++){
					iter=concepts.iterator();
					Concept selectedC=null;
					boolean found=false;
					while ((iter.hasNext())&&(!found)){
						selectedC=(Concept) iter.next();
						if (selectedC.getName().equals(selected_data[s])){
							found=true;
						}
					}
					if (found){
						list.add(selectedC);
					}
				}
				//System.out.println("ListConceptEditor: "+list.toString());
				setParameterCollection(list);
				this.fireStateChanged();

			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.stepsettings.ParameterEditor#existsOutput()
	 */
	public boolean existsOutput() {
		if (opParam.isInput())
			return false;

		Collection coll;
		Collection actual;
		for(int loop=1;loop<=numberofloops;loop++){
			coll=(Collection) this.oldparamcollections.get(loop-1);
			actual=(Collection) this.paramcollections.get(loop-1);
			if (coll==null){
				return false;
			}
			if (coll.isEmpty()){
				return false;
			}
			if (actual==null){
				actual=new LinkedList();
			}
			if (coll.size()!=actual.size()){
				return false;				
			}
		}
		
		//only returns true if in all loops the same number of concepts are specified
		return true;
	}


}
/*
$Log: ListConceptEditor.java,v $
Revision 1.3  2006/04/11 14:10:13  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:12  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:14  hakenjos
Initial version!

*/
