/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.model;

import javax.swing.JOptionPane;

import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * @author Daniel Hakenjos
 * @version $Id: MiningMartSubConcept.java,v 1.3 2006/04/11 14:10:15 euler Exp $
 */
public class MiningMartSubConcept extends ModelConnectionElement{

	private MiningMartApplication app;
	
	private boolean deleteInDatabase=true;

	public MiningMartSubConcept(){
		super();
	}
	
	/**
	 * Constructs new <code>MiningMartRelation</code> with the given parameters.
	 * @param name the name of the output- and input-concept
	 */
	public MiningMartSubConcept(MiningMartApplication app,String name, Model model,MiningMartConcept superconcept, MiningMartConcept subconcept) {
		super(name, model);
		this.setEnd(superconcept);
		this.setStart(subconcept);
		this.app=app;
	}
	
	
	/**
	 *Gets the <code>MiningMartApplication</code>.
	 */
	public MiningMartApplication getMMartApplication(){
		return app;
	}

	/**
	 * Sets the flag that this object could be deleted in the database.
	 */    
	public void setDeleteInDatabase(boolean bool){
		this.deleteInDatabase=bool;
	}
    
	/**
	 * Gets the flag indicating that this obkect can be deleted in the database.
	 */
	public boolean canDeleteInDatabase() {
		return this.deleteInDatabase;
	}
	
	public boolean canConnect(ModelFigureElement start, ModelFigureElement end) {
		if ((start instanceof MiningMartConcept)&&(end instanceof MiningMartConcept)){

			Concept superconcept=((MiningMartConcept) end).getConcept();
			Concept subconcept=((MiningMartConcept) start).getConcept();

			boolean canconnect=false;
			try {
				canconnect=superconcept.isValidSubconcept(subconcept);
			} catch (M4Exception error) {
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
				return false;
			}
			
			if (!canconnect){
				JOptionPane.showMessageDialog(app,Resource.getString("No valid subconcept: ")+subconcept.getName(),
																Resource.getString("DIALOG_ERROR_TITLE"),JOptionPane.ERROR_MESSAGE);
				return false;
			}
			return true;
		}
		return false;
	}

	/**
	 *Gets the start-class.
	 */
	protected Class getStartClass() {
		return MiningMartConcept.class;
	}

		/**
		 *Gets the start-name.
		 */
	protected String getStartName() {
		return "outgoing";
	}

	/**
	 *Gets the end class.
	 */
	protected Class getEndClass() {
		return MiningMartConcept.class;
	}

	/**
	 *Gets the end name.
	 */
	protected String getEndName() {
		return "incoming";
	}

    
	public String toString() {
		return getName() + ": " + getType();
	}

	public boolean canDestroy() {
		if (app.getViewMode()==Application.VIEWER){
			return false;
		}
		return true;
	}

	public String getType() {
		return Resource.getString("SUBCONCEPT");
	}
    
	/**
	 * Destroys this <code>MiningMartSubConcept</code> and deletes the <code>SubConcept-Relation</code>.
	 * @see org.musoft.limo.model.ModelElement#destroy()
	 */
	public void destroy() {
		if (app.getViewMode()==Application.VIEWER){
			//Im viewer-mode darf nicht zerstoert werden
			return;
		}

		if (canDeleteInDatabase()){
			MiningMartConcept superconcept=(MiningMartConcept) getEnd();
			MiningMartConcept subconcept=(MiningMartConcept) getStart();
			try {
				superconcept.getConcept().removeSubConcept(subconcept.getConcept());
			} catch (M4Exception error) {
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			}
		}

		super.destroy();
	}
	
	

	/**
	 * @see org.musoft.limo.model.ModelElement#canSetName(String)
	 */
	public boolean canSetName(String name) {
		return false;
	}
}
/*
 * Historie
 * --------
 *
 * $Log: MiningMartSubConcept.java,v $
 * Revision 1.3  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:36  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.3  2005/12/15 09:15:55  hakenjos
*** empty log message ***

Revision 1.2  2005/12/06 08:53:14  hakenjos
*** empty log message ***

Revision 1.1  2005/08/16 08:41:44  hakenjos
*** empty log message ***

*/
