/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.model;

import java.awt.Rectangle;

import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.M4Data;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * @author Timm Euler
 *
 * Abstract superclass for MiningMartConcept and others.
 * It deals with the handling of the M4 documentation.
 */
public abstract class MiningMartModelFigureElement extends ModelFigureElement {
	
	public static boolean mayChangeDocumentation = true;
	
	public MiningMartModelFigureElement(String s, Rectangle r, ModelFigureElement mfe) {
		super(s,r,mfe);
	}
	
	abstract M4Data getAttachedM4Object();
	
	/**
     * If the description of this <code>MiningMartCase</code> changed then 
     * set the documentation of the underlying <code>M4Data</code> object.
	 * @see org.musoft.limo.model.ModelElement#primitiveAttributeChanged(ModelPrimitiveAttribute)
	 */
	public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
		super.primitiveAttributeChanged(mpa);
		
		try{
			M4Data theM4 = this.getAttachedM4Object();
			if ((mpa.getName().equals("notes"))&&(theM4 != null)){
				if (MiningMartModelFigureElement.mayChangeDocumentation) {
					theM4.setDocumentation(mpa.getString());
				}
			}
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
	}
}
