/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.model;

import java.awt.Point;
import java.awt.Rectangle;

import javax.swing.JOptionPane;

import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.model.Model;
import org.musoft.limo.model.ModelAssociationEnd;
import org.musoft.limo.model.ModelAttribute;
import org.musoft.limo.model.ModelConnectionElement;
import org.musoft.limo.model.ModelFigureElement;
import org.musoft.limo.model.ModelPrimitiveAttribute;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Data;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 *A wrapper for <code>Concept</code>s.
 * @author Daniel Hakenjos
 * @version $Id: MiningMartConcept.java,v 1.4 2006/04/11 14:10:15 euler Exp $
 */
public class MiningMartConcept extends MiningMartModelFigureElement{

	private Concept concept;

	private MiningMartApplication app;
	
	private boolean deleteInDatabase=true;

	/**
	 * Creates a new <code>MiningMartConcept</code> with the given parameters.
	 */
	public MiningMartConcept(MiningMartApplication app,Concept concept,ModelFigureElement parent,Point position, Rectangle bounds) {
		super(concept.getName(), bounds, parent);
		this.concept=concept;
		this.app=app;
		this.setPosition(position);

		addAttribute(new ModelPrimitiveAttribute(this,"Type",ModelAttribute.ACCESS_READ, String.class));
		addAttribute(new ModelAssociationEnd(this, "incoming", ModelAttribute.ACCESS_READWRITE, true, StepTransition.class, "end"));
		addAttribute(new ModelAssociationEnd(this, "outgoing", ModelAttribute.ACCESS_READWRITE, true, StepTransition.class, "start"));
		try{
			((ModelPrimitiveAttribute)getAttribute("notes")).setString(concept.getDocumentation());
		}catch(M4Exception error){
		}        
		((ModelPrimitiveAttribute)getAttribute("Type")).setString(concept.getType());
		((ModelPrimitiveAttribute)getAttribute(Resource.getString("ATTR_COLOR"))).setColor(Resource.getColor("CONCEPT_NOTSELECTED_COLOR"));
		((ModelPrimitiveAttribute)getAttribute(Resource.getString("ATTR_COLOR"))).setAccess(ModelAttribute.ACCESS_READ);
	}

	/**
	 *Gets the <code>MiningMartApplication</code>.
	 */
	public MiningMartApplication getMMartApplication(){
		return app;
	}

	/**
	 * Gets the MiningMartConcepts.
	 */	
	public MiningMartConcepts getMiningMartConcepts(){
		return (MiningMartConcepts) getParent();
	}


	/**
	 * Inits this <code>MiningMartConcept</code>.
	 * It loads the attributes.
	 */
	public void initConcept(){
		
		//Add MiningMartBaseAttributes
/*		try{
			Rectangle bounds=getBounds();
			Collection c=concept.getAllBaseAttributes();
			Iterator iter=c.iterator();
			BaseAttribute baseattribute;
			MiningMartBaseAttribute mbaseattribute;
			int i=10;
			int anzahl=0;
			while ((iter.hasNext())&&(anzahl<app.getNumberOfFeatures())){
				baseattribute=(BaseAttribute) iter.next();
				mbaseattribute=new MiningMartBaseAttribute(app,baseattribute,this,new Point(bounds.x+2,bounds.y+21*(anzahl+1)),new Rectangle(bounds.x+2,bounds.y+21*(anzahl+1),bounds.width-4,20));
				addMiningMartBaseAttribute(this,mbaseattribute);
				anzahl++;
			}
			c=concept.getAllMultiColumnFeatures();
			iter=c.iterator();
			MultiColumnFeature mcfeature;
			MiningMartMultiColumnFeature mmcfeature;
			anzahl=0;
			while ((iter.hasNext())&&(anzahl<app.getNumberOfFeatures())){
				mcfeature=(MultiColumnFeature) iter.next();
				mmcfeature=new MiningMartMultiColumnFeature(app,mcfeature,this,new Point(bounds.x+2,bounds.y+21*(anzahl+1)),new Rectangle(bounds.x+2,bounds.y+21*(anzahl+1),bounds.width-4,20));
				addMiningMartMultiColumnFeature(this,mmcfeature);
				anzahl++;
			}

		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}*/
	}

	/**
	 * Adds a <code>MiningMartBaseAttribute</code> to this <code>MiningMartConcept</code>.
	 * @ return null if creating the MiningMartBaseAttribute is permitted
	 */
	public MiningMartBaseAttribute addMiningMartBaseAttribute(ModelFigureElement parent,MiningMartBaseAttribute baseattribute){


		if (!(parent instanceof MiningMartConcept)){
			return null;
		}

		for (int i = 0; i < getMiningMartConcepts().countListener(); i++) {
			getMiningMartConcepts().getModelListener(i).onCreateChild(this, baseattribute);
		}
        
		if (baseattribute.canSetParent(this) && canAddChild(baseattribute)) {
			baseattribute.setParent(this);
		}
		else {
			baseattribute.destroy();
			baseattribute = null;
		}
        
		return baseattribute;

	}

	/**
	 * Creates a new <code>MiningMartBaseAttribute</code> with the specified parameters.
	 * @param parent the MiningMartBaseAttribute is child of this <code>ModelFigureElement</code>.
	 * @param name the name of the <code>MiningMartBaseAttribute</code>
	 * @param point the <code>MiningMartBaseAttribute</code> is placed at this point.
	 * @param bounds the bounds of the figure.
	 * @return null if creating the MiningMartBaseAttribute is permitted
	 */
	public MiningMartBaseAttribute createMiningMartBaseAttribute(ModelFigureElement parent, String name, Point point, Rectangle bounds) {

		MiningMartBaseAttribute result;
		BaseAttribute baseattribute;
		try{
			name=M4Interface.getCurrentCase().getValidName(name,BaseAttribute.class);
			//concept=M4Interface.createConcept(name);
			baseattribute=null;
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			JOptionPane.showMessageDialog(app,
				error.getMessage(),
				Resource.getString("DIALOG_ERROR_TITLE"),
				JOptionPane.ERROR_MESSAGE);
			return null;
		}
        
		result = new MiningMartBaseAttribute(app,baseattribute,parent,point,bounds);

		return addMiningMartBaseAttribute(parent,result);
	}

	/**
	 * Creates a new <code>MiningMartBaseAttribute</code> with the specified parameters.
	 * @param parent the MiningMartBaseAttribute is child of this <code>ModelFigureElement</code>.
	 * @param concept the created <code>MiningMartBaseAttribute</code> wrapps this <code>BaseAttribute</code>.
	 * @param point the <code>MiningMartBaseAttribute</code> is placed at this point.
	 * @param bounds the bounds of the <code>MiningMartBaseAttribute</code>.
	 * @return null if creating the MiningMartBaseAttribute is permitted
	 */
	public MiningMartBaseAttribute createMiningMartBaseAttribute(ModelFigureElement parent, BaseAttribute baseattribute, Point point, Rectangle bounds) {

		MiningMartBaseAttribute result;
		result = new MiningMartBaseAttribute(app,baseattribute,parent,point,bounds);

		return addMiningMartBaseAttribute(parent,result);
	}

	/**
	 * Adds a <code>MiningMartMultiColumnFeature</code> to this <code>MiningMartConcept</code>.
	 * @ return null if creating the MiningMartMultiColumnFeature is permitted
	 */
	public MiningMartMultiColumnFeature addMiningMartMultiColumnFeature(ModelFigureElement parent,MiningMartMultiColumnFeature mcfeature){

		if (!( parent instanceof Model)){
			return null;
		}

		for (int i = 0; i < getListenerCount(); i++) {
			getListener(i).onCreateChild(this, mcfeature);
		}
        
		if (mcfeature.canSetParent(this) && canAddChild(mcfeature)) {
			mcfeature.setParent(this);
		}
		else {
			mcfeature.destroy();
			mcfeature = null;
		}
        
		return mcfeature;

	}

	/**
	 * Creates a new <code>MiningMartMultiColumnFeature</code> with the specified parameters.
	 * @param parent the MiningMartMultiColumnFeature is child of this <code>ModelFigureElement</code>.
	 * @param name the name of the <code>MiningMartMultiColumnFeature</code>
	 * @param point the <code>MiningMartMultiColumnFeature</code> is placed at this point.
	 * @param bounds the bounds of the figure.
	 * @return null if creating the MiningMartMultiColumnFeaturee is permitted
	 */
	public MiningMartMultiColumnFeature createMiningMartMultiColumnFeature(ModelFigureElement parent, String name, Point point, Rectangle bounds) {

		MiningMartMultiColumnFeature result;
		MultiColumnFeature mcfeature;
		try{
			name=M4Interface.getCurrentCase().getValidName(name,MultiColumnFeature.class);
			//concept=M4Interface.createConcept(name);
			mcfeature=null;
		}catch(M4Exception error){
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			JOptionPane.showMessageDialog(app,
				error.getMessage(),
				Resource.getString("DIALOG_ERROR_TITLE"),
				JOptionPane.ERROR_MESSAGE);
			return null;
		}
        
		result = new MiningMartMultiColumnFeature(app,mcfeature,parent,point,bounds);

		return addMiningMartMultiColumnFeature(parent,result);
	}

	/**
	 * Creates a new <code>MiningMartMultiColumnFeature</code> with the specified parameters.
	 * @param parent the MiningMartMultiColumnFeaturee is child of this <code>ModelFigureElement</code>.
	 * @param concept the created <code>MiningMartMultiColumnFeaturee</code> wrapps this <code>BaseAttribute</code>.
	 * @param point the <code>MiningMartMultiColumnFeature</code> is placed at this point.
	 * @param bounds the bounds of the <code>MiningMartMultiColumnFeature</code>.
	 * @return null if creating the MiningMartMultiColumnFeature is permitted
	 */
	public MiningMartMultiColumnFeature createMiningMartMultiColumnFeature(ModelFigureElement parent, MultiColumnFeature mcfeature, Point point, Rectangle bounds) {

		MiningMartMultiColumnFeature result;
		result = new MiningMartMultiColumnFeature(app,mcfeature,parent,point,bounds);

		return addMiningMartMultiColumnFeature(parent,result);
	}

	public boolean canSetParent(ModelFigureElement parent) {
		return true;
	}
	
	public String getType(){
		return Resource.getString("CONCEPT");
	}

        
	/**
	 *Gets the name of the <code>MiningMartConcept</code>.
	 *@return returns the name of the <code>Concept</code>
	 *@see edu.udo.cs.miningmart.m4.Concept#getName()
	 */
	public String getName(){
		if (concept!=null)
			return this.concept.getName();
		return "";
	}

		/**
		 *Sets the name of the <code>MiningMartConcept</code>.
		 *It means it sets the name of the <code>Concept</code>.
		 *@see edu.udo.cs.miningmart.m4.Concept#setName(String)
		 */
	public void setName(String name){
		if (concept!=null)
			this.concept.setName(name);
		super.setName(name);
	}
    
    /**
     * Gets the <code>Concept</code>.
     */
	public Concept getConcept(){
		return concept;
	}

	M4Data getAttachedM4Object() {
		return this.getConcept();
	}
	
	/**
	 * If the description of this <code>MiningMartConcept</code> changed then set the documentation of the underlying <code>Concept</code>.
	 * @see org.musoft.limo.model.ModelElement#primitiveAttributeChanged(ModelPrimitiveAttribute)
	 */
	public void primitiveAttributeChanged(ModelPrimitiveAttribute mpa) {
		super.primitiveAttributeChanged(mpa);
		if ((mpa.getName().equals(Resource.getString("ATTR_NAME")))&&(concept!=null)){
			setName(mpa.getString());
		}
		
	}

	public boolean canDestroy() {
		if (app.getViewMode()==Application.VIEWER){
			return false;
		}
		return true;
	}

	/**
	 *Destroys the <code>MiningMartConcept</code> and deletes the underlying <code>Concept</code>.
	 * @see org.musoft.limo.model.ModelElement#destroy()
	 */
	public void destroy() {
		if (app.getViewMode()==Application.VIEWER){
			//Im viewer-mode darf nicht zerstoert werden
			return;
		}

		ModelConnectionElement connection;
		Model parentmodel=(Model) getParent();
		Concept concept1,concept2;
		for (int i=parentmodel.getConnectionCount()-1;i>=0;i--){
			connection=parentmodel.getConnection(i);
			if (connection instanceof MiningMartSubConcept){
				concept1=((MiningMartConcept) connection.getStart()).getConcept();
				concept2=((MiningMartConcept) connection.getStart()).getConcept();
			}else
			if (connection instanceof MiningMartSubConcept){
				concept1=((MiningMartConcept) connection.getStart()).getConcept();
				concept2=((MiningMartConcept) connection.getStart()).getConcept();
			}else
			if (connection instanceof MiningMartSubConcept){
				concept1=((MiningMartConcept) connection.getStart()).getConcept();
				concept2=((MiningMartConcept) connection.getStart()).getConcept();
			}else{
				continue;
			}
			
			if ((concept1.equals(getConcept()))||(concept2.equals(getConcept()))){
				connection.destroy();
			}
		}
		super.destroy();

		for (int i = 0; i < getListenerCount(); i++) {
			getListener(i).onDestroy(this);
		}

		if (app.isShowingConceptPanel(this)){
			app.removeConceptPanel();
		}

		if (canDeleteInDatabase()){
			try{
				String conceptname=concept.getName();
				this.concept.deleteSoon();
				M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("DELETED_CONCEPT")+" "+conceptname);
			}catch(M4Exception error){
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			}
		}
		
	}

	/**
	 * Sets the flag that this object could be deleted in the database.
	 */
	public void setDeleteInDatabase(boolean bool, boolean propagate) {
		this.deleteInDatabase = bool;
		if (propagate) {
			for (int i = 0; i < this.getChildCount(); i++) {
				ModelFigureElement child = this.getChild(i);
				if (child instanceof MiningMartBaseAttribute) {
					((MiningMartBaseAttribute) child).setDeleteInDatabase(bool);
				}
				if (child instanceof MiningMartMultiColumnFeature) {
					((MiningMartMultiColumnFeature) child).setDeleteInDatabase(bool);
				}
			}
		}
	}
	
	/**
	 * Gets the flag indicating that this obkect can be deleted in the database.
	 */
	public boolean canDeleteInDatabase() {
		return this.deleteInDatabase;
	}
	
	
	/* (non-Javadoc)
	 * @see org.musoft.limo.model.ModelFigureElement#canAddChild(org.musoft.limo.model.ModelFigureElement)
	 */
	public boolean canAddChild(ModelFigureElement child) {
/*		if (child instanceof MiningMartBaseAttribute)
			return true;
		if (child instanceof MiningMartMultiColumnFeature)
			return true;*/
		return false;
	}

}
/*
 * Historie
 * --------
 *
 * $Log: MiningMartConcept.java,v $
 * Revision 1.4  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/02 16:49:59  euler
 * Many bugfixes
 *
 * Revision 1.1  2006/01/03 09:54:36  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.11  2005/12/15 09:15:55  hakenjos
*** empty log message ***

Revision 1.10  2005/12/06 08:53:14  hakenjos
*** empty log message ***

Revision 1.9  2005/10/20 08:58:23  hakenjos
*** empty log message ***

Revision 1.8  2005/10/11 07:57:56  hakenjos
*** empty log message ***

Revision 1.7  2005/08/25 08:20:27  hakenjos
*** empty log message ***

Revision 1.6  2005/08/23 09:03:03  hakenjos
*** empty log message ***

Revision 1.5  2005/07/20 14:00:06  hakenjos
*** empty log message ***

Revision 1.4  2005/07/19 14:20:55  hakenjos
*** empty log message ***

Revision 1.3  2005/07/19 12:18:06  hakenjos
*** empty log message ***

Revision 1.2  2005/07/07 07:51:36  hakenjos
*** empty log message ***

Revision 1.1  2005/06/22 08:31:39  hakenjos
Initial version!

 */
