/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import java.awt.Color;
import java.awt.Component;

import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

import edu.udo.cs.miningmart.m4.Feature;

/**
 * An Editro and renderer for the name of <code>Feature</code>s.
 * @author Daniel Hakenjos
 * @version $Id: NameEditor.java,v 1.3 2006/04/11 14:10:16 euler Exp $
 */
public class NameEditor extends DefaultCellEditor implements TableCellRenderer {

	private Feature feature;

	public NameEditor(Feature feature){
		super(new JTextField());
		this.feature=feature;
		((JTextField) editorComponent).setText(feature.getName());
	}

	/**
	 *Gets the <code>editorComponent</code>.
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(JTable, Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		if (isSelected){
			editorComponent.setBackground((Color) UIManager.get("Table.selectionBackground"));
		}else{
			editorComponent.setBackground((Color) UIManager.get("Table.background"));
		}
		return editorComponent;
	}


}
/*
 * Historie
 * --------
 *
 * $Log: NameEditor.java,v $
 * Revision 1.3  2006/04/11 14:10:16  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:25  hakenjos
 * Initial version!
 *
 */
