/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.concepteditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.stepsettings.ListSelectDialog;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.MultiColumnFeature;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * An editor and renderer for <code>MultiColumnFeature</code>s.
 * @author Daniel Hakenjos
 * @version $Id: MCFeatureEditor.java,v 1.3 2006/04/11 14:10:17 euler Exp $
 */
public class MCFeatureEditor  extends DefaultCellEditor implements TableCellRenderer,ItemListener, ActionListener {

	private MiningMartApplication app;

	private Concept concept;

	private MultiColumnFeature mcfeature;
	
	private JComboBox box;
	private JButton button;
	
	public MCFeatureEditor(MiningMartApplication app, MultiColumnFeature mcfeature){
		super(new JTextField());
		this.app=app;
		this.mcfeature=mcfeature;
		try {
			this.concept=mcfeature.getConcept();
		} catch (M4Exception error) {
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
		}
		
		initComponents();
		
		setDataItems();
	}

	private void initComponents(){
		JPanel panel=new JPanel(new BorderLayout());
		this.editorComponent=panel;
		setClickCountToStart(1);		

		box=new JComboBox();
		box.setBackground(Color.WHITE);
		box.setForeground(Color.BLACK);
		box.addItemListener(this);
		
		panel.add(box,BorderLayout.CENTER);
		
		button=new JButton("...");
		button.addActionListener(this);
		if (app.getViewMode()==Application.EDITOR){
			button.setEnabled(true);
		}else{
			button.setEnabled(false);
		}
		panel.add(button, BorderLayout.EAST);
		
	}
	


	/* (non-Javadoc)
	 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
	 */
	public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
		return editorComponent;
	}

	/**
	 * @see java.awt.event.ItemListener#itemStateChanged(ItemEvent)
	 */
	public void itemStateChanged(ItemEvent e) {
		if ((box.getSelectedIndex()!=0)&&(box.getItemCount()>0)){
			box.setSelectedIndex(0);
		}
	}


	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		Collection bas=null;
		try {
			bas = concept.getAllBaseAttributes();
		} catch (M4Exception error) {
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			return;
		}
		Iterator iter=bas.iterator();
		String[] data=new String[bas.size()];		
		
		BaseAttribute ba;
		int index=0;
		while(iter.hasNext()){
				ba=(BaseAttribute) iter.next();
				data[index]=ba.getName();
				index++;
		}

		Collection selbas=null;
		try {
			selbas=mcfeature.getBaseAttributes();
		} catch (M4Exception error) {
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			return;
		}
		iter=selbas.iterator();
		String[] selected_data=new String[selbas.size()];

		index=0;
		while(iter.hasNext()){
			ba=(BaseAttribute) iter.next();
			selected_data[index]=ba.getName();
			index++;
		}

		ListSelectDialog dialog=new ListSelectDialog(app,Resource.getString("FEATURE_DIALOG_TITLE"),Resource.getString("FEATURE_DIALOG_SUBTITLE"),data,selected_data,true,2,Integer.MAX_VALUE);
		if (dialog.getExitAction()==ListSelectDialog.OK){
			selected_data=dialog.getSelectedDataItems();

			LinkedList ba_list=new LinkedList();
			for(int i=0;i<selected_data.length;i++){
				try {
					ba=concept.getBaseAttribute(selected_data[i]);
				} catch (M4Exception error) {
					M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
					continue;
				}
				ba_list.add(ba);				
			}
			try {
				mcfeature.setBaseAttributes(ba_list);
			} catch (M4Exception error) {
				M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			}
			
			this.setDataItems();
		}
	}

	/**
	 *Sets the data items.
	 */
	public void setDataItems(){
		box.removeAllItems();

		Collection bas=null;
		try {
			bas = mcfeature.getBaseAttributes();
		} catch (M4Exception error) {
			M4Interface.print.doPrint(Print.ERROR,error.getMessage(),error);
			return;
		}
		Iterator iter=bas.iterator();
		
		BaseAttribute ba;
		while(iter.hasNext()){
				ba=(BaseAttribute) iter.next();
				box.addItem(ba.getName());
		}

	}
	

}
/*
 * Historie
 * --------
 *
 * $Log: MCFeatureEditor.java,v $
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:25  hakenjos
 * Initial version!
 *
 */
