/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * @author Daniel Hakenjos
 *@version $Id: VerbosityPreferencesPanel.java,v 1.4 2006/04/11 14:10:15 euler Exp $
 */
public class VerbosityPreferencesPanel extends PreferencesPanel implements ActionListener{

	private JList list;
	
	private JButton viewlogfile_button;

	public VerbosityPreferencesPanel(){
		super();
		initComponents();
	}

	private void initComponents(){

		setLayout(new BorderLayout(5,5));
		setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		
		JLabel label=new JLabel(Resource.getString("SELECT_VERBOSITY"));
		add(label,BorderLayout.NORTH);

		Collection verbosityLevelNames = Print.getAllVerbosityLevelNames(Print.MIN);
		// use Print.MIN to get all levels' names
		String[] theVerbosityNames = new String[verbosityLevelNames.size()];
		Iterator it = verbosityLevelNames.iterator();
		int i = 0;
		while (it.hasNext()) {
			theVerbosityNames[i] = (String) it.next();
			i++;
		}

		list=new JList(theVerbosityNames);	
		list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);	
		list.setSelectedValue(M4Interface.print.getMinimumVerbosityLevel().getName(),true);
				
		JScrollPane scrollpane=new JScrollPane(list);
		add(scrollpane,BorderLayout.CENTER);
		
		JPanel buttonpanel=new JPanel();
		buttonpanel.setLayout(new BorderLayout());
		add(buttonpanel,BorderLayout.SOUTH);
		
		viewlogfile_button=new JButton(Resource.getString("LOGFILEVIEWER_BUTTON"));
		viewlogfile_button.addActionListener(this);
		buttonpanel.add(viewlogfile_button,BorderLayout.EAST);

	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		LogFileViewer viewer=new LogFileViewer(null);
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.application.PreferencesPanel#actionCancel()
	 */
	public void actionCancel() {
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.application.PreferencesPanel#actionOK()
	 */
	public void actionOK() {
		actionSave();
	}

	/* (non-Javadoc)
	 * @see edu.udo.cs.miningmart.gui.application.PreferencesPanel#actionSave()
	 */
	public void actionSave() {
		M4Interface.print.setMinimumVerbosityLevel(Print.getVerbosityLevelForName((String) list.getSelectedValue()));
	}

}
/*
 * Historie
 * --------
 *
 * $Log: VerbosityPreferencesPanel.java,v $
 * Revision 1.4  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/01/10 10:07:22  hakenjos
 * All verbosity-levels are now available.
 *
 * Revision 1.1  2006/01/03 09:54:27  hakenjos
 * Initial version!
 *
 */

/*
Revision 1.3  2005/06/09 08:44:42  hakenjos
Button to open the LogFileViewer.

Revision 1.2  2005/06/07 09:27:57  hakenjos
Changes made for printing erros, messaged etc.
All properties are now in the properties-files.

Revision 1.1  2005/05/24 10:33:16  hakenjos
A Panel for the print-verbosity.

*/
