/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A dialog for setting the mode of the current case.
 * @author Daniel Hakenjos
 * @version $Id: SetModeDialog.java,v 1.3 2006/04/11 14:10:15 euler Exp $
 */
public class SetModeDialog extends JDialog implements ActionListener {

	private JButton ok, cancel;
	private JRadioButton finale, test;

	private MiningMartApplication parent;
	private Case currentcase;

	/**
	 * Constructor for SetModeDialog.
	 */
	public SetModeDialog(MiningMartApplication parent, Case currentcase) {
		super(parent, Resource.getString("CASE_SET_MODE"), true);
		this.parent=parent;
		this.currentcase = currentcase;
		initComponents();
		pack();

		this.setSize(250,130);
		Dimension size=this.getSize();

		this.setLocation(
        (Toolkit.getDefaultToolkit().getScreenSize().width-
         size.width) / 2,
        (Toolkit.getDefaultToolkit().getScreenSize().height-
         size.height) / 2);
		setVisible(true);
	}

	private void initComponents() {
		Iconkit kit = Iconkit.instance();

		JPanel panel=new JPanel();
		panel.setBorder(new EmptyBorder(10,10,10,10));
		panel.setLayout(new BorderLayout(5,5));
		
		ok = new JButton(Resource.getString("OK"));
		cancel = new JButton(Resource.getString("CANCEL"));

		ok.addActionListener(this);
		cancel.addActionListener(this);

		JPanel buttons=new JPanel();
		buttons.setLayout(new BorderLayout());

		JPanel buttons2=new JPanel();
		buttons2.setLayout(new BorderLayout());

		buttons2.add(cancel,BorderLayout.EAST);
		buttons2.add(ok,BorderLayout.CENTER);
		
		buttons.add(buttons2,BorderLayout.EAST);
		
		panel.add(buttons,BorderLayout.SOUTH);

		finale = new JRadioButton(Resource.getString("CASE_MODE_FINAL"));
		test = new JRadioButton(Resource.getString("CASE_MODE_TEST"));

		String mode = currentcase.getTheMode();
		if (mode.equals(Case.FINAL_MODE)) {
			finale.setSelected(true);
			test.setSelected(false);
		} else {
			finale.setSelected(false);
			test.setSelected(true);
		}

		ButtonGroup bGroup = new ButtonGroup();
		bGroup.add(finale);
		bGroup.add(test);

		JPanel toppanel = new JPanel();
		toppanel.setLayout(new BorderLayout());

		JPanel midpanel = new JPanel();
		midpanel.setLayout(new BoxLayout(midpanel, BoxLayout.X_AXIS));
		midpanel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
		midpanel.add(test);
		midpanel.add(finale);
		

		toppanel.add(midpanel, BorderLayout.CENTER);

		toppanel.add(new JLabel(Resource.getString("CASE_SET_THE_MODE")),BorderLayout.NORTH);

		panel.add(new JLabel((new ImageIcon(kit.loadImageResource(
					Resource.getString("INFORMATION_ICON"))))),BorderLayout.WEST);

		panel.add(toppanel,BorderLayout.CENTER);
		this.getContentPane().add(panel);
	}

	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		String cmd = e.getActionCommand();

		if (cmd.equals(Resource.getString("CANCEL"))) {
			this.dispose();
		}
		if (cmd.equals(Resource.getString("OK"))) {
			try {
				if (finale.isSelected())
					currentcase.setTheMode(Case.FINAL_MODE);
				else
					currentcase.setTheMode(Case.TEST_MODE);
					
				M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("SET_THE_MODE")+" "+currentcase.getTheMode());
			} catch (M4Exception error) {
				M4Interface.print.doPrint(Print.ERROR, Resource.getString("CASE_SET_MODE_ERRORMESSAGE")+"\n"+error.getMessage(), error);
				JOptionPane.showMessageDialog(parent,Resource.getString("CASE_SET_MODE_ERRORMESSAGE")+"\n"+error.getMessage(),Resource.getString("DIALOG_ERROR_TITLE"),JOptionPane.ERROR_MESSAGE);
			}
			this.dispose();
		}
	}

}
/*
$Log: SetModeDialog.java,v $
Revision 1.3  2006/04/11 14:10:15  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:14  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:26  hakenjos
Initial version!

*/
