/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.border.Border;

import org.musoft.limo.application.Resource;

/**
 * A dialog to show the user a statement.
 * It contains a <code>JProgressBar</code> with indeterminate.
 * @author Daniel Hakenjos
 * @version $Id: OpeningCaseDialog.java,v 1.3 2006/04/11 14:10:15 euler Exp $
 */
public class OpeningCaseDialog extends JDialog{

	private String text, casename;
	
	private JLabel textlabel; 

    public static final int ONE_SECOND=1000;
    public static final int MILLI_SECOND=100;

    private JProgressBar progressbar;
    private OpenCaseThread thread;
    
    private Timer timer;
    private int value=0;


	/**
	 * Constructor for OpeningCaseDialog.
	 */
	public OpeningCaseDialog(MiningMartApplication parent, String casename,OpenCaseThread thread) {
		super(parent,Resource.getString("OPENING_CASE"),false);

		this.thread=thread;
		this.text=thread.getComment();

		this.casename=casename;

		initComponents();
		initTimer();		
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
	
		this.pack();

		Dimension size = this.getSize();

		this.setLocation(
			(Toolkit.getDefaultToolkit().getScreenSize().width - size.width)
				/ 2,
			(Toolkit.getDefaultToolkit().getScreenSize().height - size.height)
				/ 2);
		this.setVisible(true);

	}
	
	/**
	 * Get the text.
	 */
	public String getText(){
		return text;
	}
	
	/**
	 * Set the text.
	 */
	public void setText(String text){
		this.text=text;
		textlabel.setText(text);
		textlabel.repaint();
	}
	
	private void initComponents(){
		Border emptyborder=BorderFactory.createEmptyBorder(5,10,5,10);
		Border emptyborder2=BorderFactory.createEmptyBorder(5,0,5,0);

		JPanel toppanel=new JPanel();
		toppanel.setLayout(new BorderLayout(5,5));
		toppanel.setBorder(emptyborder);
		this.getContentPane().add(toppanel);
	
		JLabel titlelabel=new JLabel();
		titlelabel.setText(Resource.getString("TITLE_OPENING_CASE")+" "+casename);
		Font titlefont=new Font("SansSerif",Font.PLAIN,14);
		titlelabel.setFont(titlefont);
		titlelabel.setForeground(Color.BLACK);
		titlelabel.setBorder(emptyborder2);
		toppanel.add(titlelabel,BorderLayout.NORTH);
		
		textlabel=new JLabel();
		textlabel.setHorizontalAlignment(SwingConstants.CENTER);
		textlabel.setVerticalAlignment(SwingConstants.CENTER);
		Font textfont=new Font("SansSerif",Font.PLAIN,12);
		textlabel.setFont(textfont);
		textlabel.setForeground(Color.BLUE);
		textlabel.setText(text);
		toppanel.add(textlabel,BorderLayout.CENTER);
		
		progressbar=new JProgressBar(0,1000);
        progressbar.setValue(0);
        progressbar.setIndeterminate(true);
        progressbar.setStringPainted(false);
        
        Dimension d=new Dimension(300,25);
        progressbar.setMaximumSize(d);
        progressbar.setMinimumSize(d);
        progressbar.setPreferredSize(d);
        

        JPanel center=new JPanel();
        center.setBorder(BorderFactory.createEmptyBorder(25,25,25,25));
        center.add(progressbar);
		toppanel.add(center,BorderLayout.SOUTH);
	}

    
    
    
    private void initTimer(){
        value=0;
        timer = new Timer(ONE_SECOND, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
            	
            	if (!thread.isReady()){
            		setText(thread.getComment());
            	}
            	else{
                    dispose();
            	}
            }
        });

    
    }
    
    /**
     * @see java.awt.Component#setVisible(boolean)
     */
    public void setVisible(boolean visible) {
    	if (visible)
	        timer.start();
        super.setVisible(visible);
    }

}
/*
$Log: OpeningCaseDialog.java,v $
Revision 1.3  2006/04/11 14:10:15  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:27  hakenjos
Initial version!

*/
