/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import javax.swing.JOptionPane;

import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.M4Interface.CaseLockedException;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A <code>Thread</code> for opening a case.
 * The <code>Thread</code> is necessary because of the <code>JProgressBar</code> in the <code>OpeningCaseDialog</code>.
 * @author Daniel Hakenjos
 * @version $Id: OpenCaseThread.java,v 1.4 2006/04/11 14:10:16 euler Exp $
 */
public class OpenCaseThread extends Thread{

	private MiningMartApplication app;

	private String casename;
	
	private boolean opened;

	private boolean openCaseForUpdating;
	private boolean ready;
	private boolean caseHasChanged;
	
	private String comment;

	/**
	 * Constructor for OpenCaseThread.
	 */
	public OpenCaseThread(
			MiningMartApplication app, 
			String casename, 
			boolean openCaseForUpdating,
			boolean caseHasChanged) {
		this.app=app;
		this.casename=casename;
		opened=false;
		ready=false;
		this.caseHasChanged = caseHasChanged;
		this.openCaseForUpdating=openCaseForUpdating;
		this.comment=Resource.getString("LOADING_CASE");
	}

	/**
	 * Is the case open?
	 */
	public boolean isOpened(){
		return opened;
	}	
	
	/**
	 * Gets the comment
	 */
	public String getComment(){
		return comment;
	}
	
	/**
	 * Is it ready?
	 */
	public boolean isReady(){
		return ready;
	}
	

	/**
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		//app.showMemoryUsage();
//		long zeit=System.currentTimeMillis();
			app.setActualCaseName(casename);
//			OpeningCaseDialog opening=new OpeningCaseDialog(app,casename,"Loading case from databse...");

			try{
				if (!openCaseForUpdating){
					if (this.caseHasChanged) app.currentcase=MiningMartApplication.m4Interface.findCaseForReadOnlyAccess(casename,true);
					app.setViewMode(Application.VIEWER);
				}
				else{
					if (this.caseHasChanged) app.currentcase=MiningMartApplication.m4Interface.findCaseForUpdate(casename,true);
					app.setViewMode(Application.EDITOR);
				}
			}catch(CaseLockedException e){
				M4Interface.print.doPrint(Print.ERROR,Resource.getString("ERROR_LOCKED_CASE")+" "+casename,e);
				
				if (MiningMartApplication.m4Interface.canRemoveM4Access(casename)){
					
					String message =Resource.getString("ERROR_LOCKED_CASE")+" "+casename+"\n"
											+Resource.getString("REMOVE_CASELOCK1")+"\n"
											+Resource.getString("REMOVE_CASELOCK2");
											
					int confirm=JOptionPane.showConfirmDialog(app,message,Resource.getString("ERROR_LOCKED_CASE_TITLE"),JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
					if (confirm==JOptionPane.YES_OPTION){
						MiningMartApplication.m4Interface.releaseCaseWithoutStoring(casename);
					}
					
				}else{
					JOptionPane.showMessageDialog(app,Resource.getString("ERROR_LOCKED_CASE")+" "+casename,Resource.getString("ERROR_LOCKED_CASE_TITLE"),JOptionPane.WARNING_MESSAGE);
				}
				ready=true;
				return;
			}
			
			
			((MiningMartMenuBar) app.getJMenuBar()).promptOpenItemStates();
			((MiningMartToolBar) app.getToolbar()).promptOpenItemStates();

			comment=Resource.getString("CREATE_MODEL");
			app.setModel(app.createModel());

			comment=Resource.getString("CREATE_DRAWINGVIEW");
			app.createDrawing(app.getModel());

			app.getModel().setDirty(false);

			app.modelLoaded();

			comment=Resource.getString("ADD_NAVIGATOR");
			app.showComponentInTab(app.getNavigator(), Application.PANE_LEFT_TOP, true);

			comment=Resource.getString("ADD_CONCEPTEDITOR");

			comment=Resource.getString("ADD_BIRDSEYE");
			app.showComponentInTab(app.getBirdsEye(), Application.PANE_LEFT_TOP, false);

			comment=Resource.getString("ADD_INSPECTOR");
			app.showComponentInTab(app.getInspector(), Application.PANE_LEFT_BOTTOM, true);
			app.showComponentInTab(app.getNotepad(), Application.PANE_LEFT_BOTTOM, false);

			comment=Resource.getString("ADD_ANNOTATION");
//			app.showComponentInTab(app.getHypertextViewer(), app.PANE_RIGHT, true);
			app.showAnnotations();
	
			if ((app.getViewMode()==Application.EDITOR)&&(app.getEditorMode()==MiningMartApplication.CASE_MODE)){
				comment=Resource.getString("ADD_OPTOOLS");
				OperatorToolPanel operatortoolpanel=new OperatorToolPanel(app); 
				app.setOperatorToolPanel(operatortoolpanel);
//    			app.showComponentInTab(operatortoolpanel.getOperatorToolPanel(),app.PANE_RIGHT,false);
				app.showOperatorTools();
			}else if ((app.getViewMode()==Application.EDITOR)&&(app.getEditorMode()==MiningMartApplication.CONCEPT_MODE)){
				comment=Resource.getString("ADD_CONCEPTTOOLS");
				ConceptToolPanel concepttoolpanel=new ConceptToolPanel(app);
				app.setConceptToolPanel(concepttoolpanel);
				app.showConceptTools();
			}else{
			}
			
			((MiningMartMenuBar) app.getJMenuBar()).setItemState(
				Resource.getString("MENU_CASE")+"."	+ Resource.getString("MENU_CASE_SAVE"),false);
			((MiningMartToolBar) app.getToolbar()).enableTool(Resource.getString("TOOL_SAVECASE"),false);
	
			((MiningMartMenuBar) app.getJMenuBar()).getRecentCases().setRecentFile(casename);
			((MiningMartMenuBar) app.getJMenuBar()).setRecentCasesGUI();

			comment=Resource.getString("OPENCASE_READY");
			
			if (this.caseHasChanged) M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("OPENED_CASE")+" "+M4Interface.getCurrentCase().getName());
			
			app.activateFrameOfElement(app.getModel());
		
			ready=true;
//		zeit=System.currentTimeMillis()-zeit;
//		System.out.println("zeit: "+zeit+"ms");
//		app.showMemoryUsage();
	}
}
/*
$Log: OpenCaseThread.java,v $
Revision 1.4  2006/04/11 14:10:16  euler
Updated license text.

Revision 1.3  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.2  2006/03/22 13:08:52  euler
*** empty log message ***

Revision 1.1  2006/01/03 09:54:26  hakenjos
Initial version!

*/
