/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.m4.Concept;

/**
 * A small dialog to create a new concept.
 * The user define the type.
 * @author Daniel Hakenjos
 * @version $Id: NewConceptDialog.java,v 1.3 2006/04/11 14:10:15 euler Exp $
 */
public class NewConceptDialog extends JDialog implements ActionListener{

	public final int CANCEL=0;
	public final int OK=1;

	private JTextField field;
	private JButton cancel, ok;
	private JRadioButton db,mining;
	
	private int exitAction;

	public NewConceptDialog(MiningMartApplication parent){
		super(parent, Resource.getString("DIALOG_NEW_CONCEPT_TITLE"), true);
		
		this.exitAction=CANCEL;	
		initComponents();
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		
		this.pack();

		setSize(250,150);

		Dimension size=this.getSize();

		this.setLocation(
		(Toolkit.getDefaultToolkit().getScreenSize().width-
		 size.width) / 2,
		(Toolkit.getDefaultToolkit().getScreenSize().height-
		 size.height) / 2);
		this.setVisible(true);
	}
	
	/**
	 * Inits the components.
	 */
	public void initComponents(){
		
		JPanel top_panel=new JPanel();
		top_panel.setLayout(new BorderLayout(5,5));
		
		
		cancel=new JButton(Resource.getString("CANCEL"));
		ok=new JButton(Resource.getString("OK"));
		ok.setEnabled(true);
		
		cancel.addActionListener(this);
		ok.addActionListener(this);
		
		field=new JTextField();
		field.setText(Resource.getString("CONCEPT"));
		
		JLabel label=new JLabel(Resource.getString("CONCEPT")+":");
		
		JPanel textpanel=new JPanel();
		textpanel.setLayout(new BorderLayout(5,0));
		textpanel.add(label,BorderLayout.WEST);
		textpanel.add(field, BorderLayout.CENTER);
		
		JPanel mid_panel=new JPanel();
		mid_panel.setLayout(new BorderLayout(5,0));
		mid_panel.add(textpanel, BorderLayout.NORTH);
		top_panel.add(mid_panel,BorderLayout.CENTER);
		
		JPanel bottom=new JPanel();
		bottom.setLayout(new BoxLayout(bottom, BoxLayout.X_AXIS));
		bottom.add(Box.createHorizontalGlue());
		bottom.add(ok);
		bottom.add(Box.createRigidArea(new Dimension(10, 0)));
		bottom.add(cancel);
		top_panel.add(bottom,BorderLayout.SOUTH);
		
		top_panel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

		db=new JRadioButton(Concept.TYPE_DB);
		mining=new JRadioButton(Concept.TYPE_MINING);
		ButtonGroup group=new ButtonGroup();
		group.add(db);
		group.add(mining);
		db.setSelected(true);

		JPanel rbuttonpanel=new JPanel();
		rbuttonpanel.setLayout(new BoxLayout(rbuttonpanel, BoxLayout.X_AXIS));
		rbuttonpanel.add(new JLabel(Resource.getString("DIALOG_NEW_CONCEPT_TYPE")));
		rbuttonpanel.add(db);
		rbuttonpanel.add(mining);
		rbuttonpanel.add(Box.createHorizontalGlue());
		mid_panel.add(rbuttonpanel,BorderLayout.CENTER);

		this.getContentPane().add(top_panel);
	}
	
	
	/**
	 * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
	 */
	public void actionPerformed(ActionEvent e){
		String cmd=e.getActionCommand();
		if (cmd.equals(Resource.getString("CANCEL"))){
			exitAction=CANCEL;
			this.dispose();
		}
		if (cmd.equals(Resource.getString("OK"))){
			exitAction=OK;
			this.dispose();
		}
	}
	
	/**
	 * Gets the exit-action.
	 */
	public int getExitAction(){
		return exitAction;
	}
	
	/**
	 * Gets the name of the new concept.
	 */
	public String getNewConceptName(){
		if (exitAction==OK)
			return field.getText();
		return null;
	}
	
	/**
	 * Gets the type of the concept. See Concept.TYPE_ ....
	 */
	public String getConceptType(){
		if (db.isSelected())
			return Concept.TYPE_DB;		
		
		return Concept.TYPE_MINING;
	}
	

}
/*
 * Historie
 * --------
 *
 * $Log: NewConceptDialog.java,v $
 * Revision 1.3  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:15  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:26  hakenjos
 * Initial version!
 *
 */
