/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;


import javax.swing.ImageIcon;

import org.jhotdraw.framework.Drawing;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.JHotDrawRuntimeException;
import org.jhotdraw.standard.AbstractTool;
import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Application;
import org.musoft.limo.application.Resource;
import org.musoft.limo.application.StaticJButton;
import org.musoft.limo.application.ToolBar;
import org.musoft.limo.model.ModelFigureElement;

import edu.udo.cs.miningmart.m4.M4Interface;



/**
 * A ToolBar for the <code>MiningMartApplication</code>.
 * @author Daniel Hakenjos
 * @version $Id: MiningMartToolBar.java,v 1.5 2006/04/11 14:10:15 euler Exp $
 */
public class MiningMartToolBar extends ToolBar {

	private Application parent;

	public MiningMartToolBar(Application p){
		super(p);
		parent = getParentApplication();
		
		this.setFloatable(false);
		
		this.removeAll();

	    createCaseTools();
	    //createChainTools();
	    createCompileTools();
		//createStateTools();
	    createHelpTools();
	    		  
		addGroup("case");
		showGroup("case", ToolBar.ACTIVE);
//		addGroup("chain");
//		showGroup("chain", ToolBar.ACTIVE);
		addGroup("compile");
		showGroup("compile", ToolBar.ACTIVE);
//		addGroup("state");
//		showGroup("state", ToolBar.ACTIVE);
		addGroup("help");
		showGroup("help", ToolBar.ACTIVE);

		initToolStates();

	}
	
	/**
	 * Sets the initial states of the tools.
	 */
	public void initToolStates(){
		enableTool(Resource.getString("TOOL_EXPORTCASE"),false);
		enableTool(Resource.getString("TOOL_SAVECASE"),false);
		enableTool(Resource.getString("TOOL_PRINTCASE"),false);
		enableTool(Resource.getString("TOOL_CUT"),false);
		enableTool(Resource.getString("TOOL_COPY"),false);
		enableTool(Resource.getString("TOOL_PASTE"),false);
		enableTool(Resource.getString("TOOL_DELETE"),false);
		enableTool(Resource.getString("TOOL_VALIDATE"),false);
		enableTool(Resource.getString("TOOL_VALIDATEALL"),false);
		enableTool(Resource.getString("TOOL_GARBAGE"),false);
		enableTool(Resource.getString("TOOL_COMPILEALL"),false);
		enableTool(Resource.getString("TOOL_COMPILEFROMSELECTED"),false);
		enableTool(Resource.getString("TOOL_COMPILEUNTILSELECTED"),false);
		enableTool(Resource.getString("TOOL_COMPILESTEP"),false);
		enableTool(Resource.getString("TOOL_SWITCH_EDITOR"),false);
	}
	
	/**
	 * Sets the states of the tools when opening a case.
	 */
	public void promptOpenItemStates(){
		enableTool(Resource.getString("TOOL_EXPORTCASE"),true);
		enableTool(Resource.getString("TOOL_PRINTCASE"),true);
		enableTool(Resource.getString("TOOL_ALL_TRANSITIONS"),true);
		enableTool(Resource.getString("TOOL_SHOW_STEPSETTINGS"),true);
		enableTool(Resource.getString("TOOL_SWITCH_EDITOR"),true);
		if (parent.getViewMode()==Application.EDITOR){
			enableTool(Resource.getString("TOOL_CUT"),true);
			enableTool(Resource.getString("TOOL_COPY"),true);
			enableTool(Resource.getString("TOOL_PASTE"),true);
			enableTool(Resource.getString("TOOL_DELETE"),true);
			enableTool(Resource.getString("TOOL_VALIDATE"),true);
			enableTool(Resource.getString("TOOL_VALIDATEALL"),true);
			enableTool(Resource.getString("TOOL_GARBAGE"),true);
		}
		promptSwitchEditor();
	}
	
	/**
	 * Sets the state of the compile menu-items when the compilation starts.
	 */
	public void promptStartCompilationItemStates(){
		enableTool(Resource.getString("TOOL_COMPILEALL"),false);
		enableTool(Resource.getString("TOOL_COMPILEFROMSELECTED"),false);
		enableTool(Resource.getString("TOOL_COMPILEUNTILSELECTED"),false);
		enableTool(Resource.getString("TOOL_COMPILESTEP"),false);
	}
	
	/**
	 * Sets the state of the compile menu-items when the compilation is done.
	 */
	public void promptDoneCompilationItemStates(){
		enableTool(Resource.getString("TOOL_COMPILEALL"),true);
		enableTool(Resource.getString("TOOL_COMPILEFROMSELECTED"),true);
		enableTool(Resource.getString("TOOL_COMPILEUNTILSELECTED"),true);
		enableTool(Resource.getString("TOOL_COMPILESTEP"),true);
	}
	
	public void promptSwitchEditor(){
		if (((MiningMartApplication) parent).getEditorMode()==MiningMartApplication.CASE_MODE){
			if (parent.getViewMode()==Application.EDITOR){
				enableTool(Resource.getString("TOOL_COMPILEALL"),true);
				enableTool(Resource.getString("TOOL_COMPILEFROMSELECTED"),true);
				enableTool(Resource.getString("TOOL_COMPILEUNTILSELECTED"),true);
				enableTool(Resource.getString("TOOL_COMPILESTEP"),true);
			}
		}else{
		}
	}

	/**
	 * Sets the states of the tools for a new case.
	 */
	public void promptNewToolStates(){
		promptOpenItemStates();
	}
	
	/**
	 * Sets the states of the tools when closing a case.
	 */
	public void promptCloseToolStates(){
		initToolStates();
	}
	
	/**
	 * Erzeugen der Tools for Case-Opening etc.
	 * 
	 */
	protected void createCaseTools(){
		
		// use a Mediatracker to ensure that all the images are initially loaded
		Iconkit kit = Iconkit.instance();
		if (kit == null) {
			throw new JHotDrawRuntimeException("Iconkit instance isn't set");
		}
		
		// new CASE
		StaticJButton button;
		button = new StaticJButton(Resource.getString("TOOL_NEWCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_NEWCASE"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_NEWCASE"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
		    	if (((StaticJButton)evt.getSource()).isEnabled())
		    		parent.promptNew();
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_NEWCASE"));
		this.addButton("case", button);

		//open CASE
		button = new StaticJButton(Resource.getString("TOOL_OPENCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_OPENCASE"))));
	    button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_OPENCASE"))));
		button.setBorder(null);
        button.addMouseListener(
        new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
				if (((StaticJButton)evt.getSource()).isEnabled())
	            	parent.promptOpen();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_OPENCASE"));
        this.addButton("case", button);

		//view CASE
/*		button = new StaticJButton(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_VIEWCASE"))));
	    button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_VIEWCASE"))));
		button.setBorder(null);
        button.addMouseListener(
        new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
				if (((StaticJButton)evt.getSource()).isEnabled())
	            	((MiningMartApplication) parent).promptOpen(null,true);
            }
        });
        button.setToolTipText(Resource.getString("TOOL_VIEWCASE"));
        this.addButton("case", button);
*/
		//save case
		button = new StaticJButton(Resource.getString("TOOL_SAVECASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_SAVECASE"))));
	    button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_SAVECASE"))));
		button.setBorder(null);
        button.addMouseListener(
        new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
				if (((StaticJButton)evt.getSource()).isEnabled())
		        	parent.saveModel();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_SAVECASE"));
        this.addButton("case", button);
		

		//import CASE
		button = new StaticJButton(Resource.getString("TOOL_IMPORTCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_IMPORTCASE"))));
	    button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_IMPORTCASE"))));
		button.setBorder(null);
        button.addMouseListener(
        new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
				if (((StaticJButton)evt.getSource()).isEnabled())
		        	((MiningMartApplication) parent).importCase();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_IMPORTCASE"));
        this.addButton("case", button);

		//export CASE
		button = new StaticJButton(Resource.getString("TOOL_EXPORTCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_EXPORTCASE"))));
	    button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_EXPORTCASE"))));
		button.setBorder(null);
        button.addMouseListener(
        new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
				if (((StaticJButton)evt.getSource()).isEnabled())
		        	((MiningMartApplication) parent).exportCase();
            }
        });
        button.setToolTipText(Resource.getString("TOOL_EXPORTCASE"));
        this.addButton("case", button);
        
        //print case
		button = new StaticJButton(Resource.getString("TOOL_PRINTCASE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_PRINTCASE"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_PRINTCASE"))));
		button.setBorder(null);
		button.addMouseListener(
		new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				if (((StaticJButton)evt.getSource()).isEnabled())
					parent.promptPrint(true);
			}
		});
		button.setToolTipText(Resource.getString("TOOL_PRINTCASE"));
		this.addButton("case", button);


	}
	
	/**
	 * Creates Chain-Tools.
	 */
	protected void createChainTools(){
		
		// use a Mediatracker to ensure that all the images are initially loaded
		Iconkit kit = Iconkit.instance();
		if (kit == null) {
			throw new JHotDrawRuntimeException("Iconkit instance isn't set");
		}
		
		// new CASE
		StaticJButton button;

		button = new StaticJButton(Resource.getString("TOOL_CUT"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_CUT"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_CUT"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
		    		
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_CUT"));
		this.addButton("chain", button);
		
		button = new StaticJButton(Resource.getString("TOOL_COPY"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COPY"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COPY"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
		    		
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_COPY"));
		this.addButton("chain", button);

		button = new StaticJButton(Resource.getString("TOOL_PASTE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_PASTE"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_PASTE"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
		    		
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_PASTE"));
		this.addButton("chain", button);
		
		button = new StaticJButton(Resource.getString("TOOL_DELETE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_DELETE"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_DELETE"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
		    		
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_DELETE"));
		this.addButton("chain", button);
	}

	/**
	 * Creates tools for compiling.
	 */
	protected void createCompileTools(){
		
		// use a Mediatracker to ensure that all the images are initially loaded
		Iconkit kit = Iconkit.instance();
		if (kit == null) {
			throw new JHotDrawRuntimeException("Iconkit instance isn't set");
		}
		
	
		StaticJButton button;
/*
		button = new StaticJButton(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_VALIDATE"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_VALIDATE"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
		    }      
		}  );
		button.setToolTipText(Resource.getString("TOOL_VALIDATE"));
		this.addButton("compile", button);

		button = new StaticJButton(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_VALIDATEALL"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_VALIDATEALL"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_VALIDATEALL"));
		this.addButton("compile", button);
*/
		button = new StaticJButton(Resource.getString("TOOL_COMPILEALL"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COMPILEALL"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COMPILEALL"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
				((MiningMartApplication) parent).compileAll();
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_COMPILEALL"));
		this.addButton("compile", button);

		button = new StaticJButton(Resource.getString("TOOL_COMPILEFROMSELECTED"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COMPILEFROMSELECTED"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COMPILEFROMSELECTED"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
				((MiningMartApplication) parent).compileFrom();
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_COMPILEFROMSELECTED"));
		this.addButton("compile", button);

		button = new StaticJButton(Resource.getString("TOOL_COMPILEUNTILSELECTED"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COMPILEUNTILSELECTED"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COMPILEUNTILSELECTED"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
				((MiningMartApplication) parent).compileUntil();
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_COMPILEUNTILSELECTED"));
		this.addButton("compile", button);

		button = new StaticJButton(Resource.getString("TOOL_COMPILESTEP"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_COMPILESTEP"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_COMPILESTEP"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
				((MiningMartApplication) parent).compileStep();
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_COMPILESTEP"));
		this.addButton("compile", button);

		button = new StaticJButton(Resource.getString("TOOL_GARBAGE"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_GARBAGE"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_GARBAGE"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
		    public void mouseClicked(java.awt.event.MouseEvent evt) {
//		    	if (((StaticJButton)evt.getSource()).isEnabled())
				((MiningMartApplication) parent).collectGarbage();
		    }      
		});
		button.setToolTipText(Resource.getString("TOOL_GARBAGE"));
		this.addButton("compile", button);

	}
	
	/**
	 * Creates Help-Tools.
	 */
	protected void createHelpTools(){
		
		// use a Mediatracker to ensure that all the images are initially loaded
		Iconkit kit = Iconkit.instance();
		if (kit == null) {
			throw new JHotDrawRuntimeException("Iconkit instance isn't set");
		}
		
		
		StaticJButton button;

		button = new StaticJButton(Resource.getString("TOOL_SWITCH_EDITOR"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_SWITCH_EDITOR"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_SWITCH_EDITOR"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				MiningMartApplication app=((MiningMartApplication) parent);

				app.saveModel();
				String casename=app.getModel().getName();
				if (app.getEditorMode()==MiningMartApplication.CONCEPT_MODE){
					casename=M4Interface.getCurrentCase().getName();
				}

				boolean editing=app.getViewMode()==Application.EDITOR;
				MiningMartApplication.keepCase = true;
				app.promptClose();

				if (app.getEditorMode()==MiningMartApplication.CONCEPT_MODE){
					app.setEditorMode(MiningMartApplication.CASE_MODE);
				}else{
					app.setEditorMode(MiningMartApplication.CONCEPT_MODE);
				}
				app.promptOpen(casename,editing);
				MiningMartApplication.keepCase = false;
			}      
		});
		button.setToolTipText(Resource.getString("TOOL_SWITCH_EDITOR"));
		this.addButton("help", button);
		
		button = new StaticJButton(Resource.getString("TOOL_HELP"), new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG1_HELP"))));
		button.setPressedIcon(new ImageIcon(kit.loadImageResource(Resource.getString("TOOLIMG2_HELP"))));
		button.setBorder(null);
		button.addMouseListener(        
		new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				((MiningMartApplication) parent).showHelp();
			}      
		});
		button.setToolTipText(Resource.getString("TOOL_HELP"));
		this.addButton("help", button);
		
	}
	
	/**
	 * Creates tools for steps.
	 */
	protected void createStateTools() {
		// use a Mediatracker to ensure that all the images are initially loaded
/*		Iconkit kit = Iconkit.instance();
		if (kit == null) {
			throw new JHotDrawRuntimeException("Iconkit instance isn't set");
		}



		Tool tool =new MyAbstractTool(Resource.getString("TOOL_CONCEPT"),parent){
			public void mouseDown(MouseEvent e, int x, int y) {
				super.mouseDown(e, x, y);
				ModelFigureElement p = getPotentialParent(x, y, drawing());
				
				MiningMartConcept s = null;
				
				if (p instanceof MiningMartConcepts){

					s = ((MiningMartConcepts) p).createMiningMartConcept(p,Resource.getString("CONCEPT"), new Point(x,y), new Rectangle(x,y,60,100));
				}
				else{
					//offensichtlich liegt ein Fehler vor
					return;
				}
				editor().toolDone();
				if (s != null){
					parent.selectFigure(s);
					M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL,Resource.getString("INSERTED_NEW_CONCEPT")+" "+s.getName());
				}
			}
		};
		JButton button=createMyToolButton(Resource.getString("TOOLIMG_CONCEPT"), Resource.getString("TOOL_CONCEPT"), tool);
		button.setToolTipText(Resource.getString("TOOL_CONCEPT"));
		addButton("state",button);
*/
	}
	
	
	public ModelFigureElement getPotentialParent(int x,int y, Drawing drawing){
		return super.getPotentialParent(x,y,drawing);
	}

	private class MyAbstractTool extends AbstractTool{

		private String name;

		public MyAbstractTool(String name, DrawingEditor drawingeditor){
			super(drawingeditor);
			this.name=name;
		}
		
		public String getName(){
			return name;
		}
	}

}
/*
$Log: MiningMartToolBar.java,v $
Revision 1.5  2006/04/11 14:10:15  euler
Updated license text.

Revision 1.4  2006/04/06 16:31:14  euler
Prepended license remark.

Revision 1.3  2006/03/22 13:08:52  euler
*** empty log message ***

Revision 1.2  2006/01/10 07:52:47  hakenjos
Save the model before switching to Concept- or Case-Editor.

Revision 1.1  2006/01/03 09:54:27  hakenjos
Initial version!

*/
