/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.jhotdraw.util.Iconkit;
import org.musoft.limo.application.Resource;


/**
 * A GUI-Object to display an data-item in the center and two iterator-utilizies on the right.
 * So you can iterate over an array.
 * @author Daniel Hakenjos
 * @version $Id: IteratorList.java,v 1.3 2006/04/11 14:10:16 euler Exp $
 */
public class IteratorList extends JPanel {

	private JTextField textlabel;

	private String[] data;
	private boolean dataset = false;

	private int selection = 0; // number of text to displayed
	
	private Vector iterlistener;

	public IteratorList() {
		iterlistener=new Vector();
		initComponents();
	}

	/**
	 * Construct <code>IteratorList</code> with array of items to be displayed.
	 */
	public IteratorList(String[] data) {
		this();
		setData(data);
	}
	
	/**
	 * Adds an <code>IteratorListener</code>.
	 */
	public void addIteratorListener(IteratorListener listener){
		iterlistener.add(listener);
	}
	
	/**
	 * Removes an <code>IteratorListener</code>.
	 */
	public void removeIteratorListener(IteratorListener listener){
		iterlistener.remove(listener);
	}

	/**
	 * Removes all <code>IteratorListener</code>.
	 */	
	public void reamoveAllIteratorListener(){
		iterlistener.clear();
	}
	
	/**
	 * Gets the number of all <code>IteratorListener</code>.
	 */
	public int getIteratorListenerCount(){
		return iterlistener.size();
	}
	
	/**
	 * Gets an <code>IteratorListener</code> by its index.
	 */
	public IteratorListener getIteratorListener(int index){
		return (IteratorListener) iterlistener.get(index);
	}

	/**
	 * Set the data. 
	 * First item is going to be displayed.
	 */
	public void setData(String[] data) {
		this.data = data;
		setFirst();
		dataset = true;
	}
	
	/**
	 * The first item will be displayed.
	 */
	public void setFirst() {
		textlabel.setText(data[0]);
		selection = 0;
	}

	/**
	 * The last item will be displayed.
	 */
	public void setLast() {
		textlabel.setText(data[data.length-1]);
		selection = data.length-1;
	}


	/**
	 * Get the data.
	 */

	public String[] getData() {
		return data;
	}

	private void initComponents(){
		this.setLayout(new BorderLayout());
		this.setBackground(Color.WHITE);
		setBorder(BorderFactory.createLineBorder(Color.black));
		Iconkit kit = Iconkit.instance();
		
		ImageIcon upicon =new ImageIcon(kit.loadImageResource(Resource.getString("LOOP_UP_ICON")));
		ImageIcon downicon =new ImageIcon(kit.loadImageResource(Resource.getString("LOOP_DOWN_ICON")));


		JLabel uplabel=new JLabel();
		uplabel.setBackground(Color.WHITE);
		uplabel.setMaximumSize(new Dimension(10, 5));
		uplabel.setMinimumSize(new Dimension(10, 5));
		uplabel.setPreferredSize(new Dimension(10, 5));
		uplabel.setHorizontalAlignment(SwingConstants.RIGHT);
		uplabel.setHorizontalTextPosition(SwingConstants.LEADING);
		uplabel.setIcon(upicon);
		uplabel.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				next();
			}
		});

		JLabel downlabel=new JLabel();
		downlabel.setBackground(Color.WHITE);
		downlabel.setMaximumSize(new Dimension(10, 5));
		downlabel.setMinimumSize(new Dimension(10, 5));
		downlabel.setPreferredSize(new Dimension(10, 5));
		downlabel.setHorizontalAlignment(SwingConstants.RIGHT);
		downlabel.setHorizontalTextPosition(SwingConstants.LEADING);
		downlabel.setIcon(downicon);
		downlabel.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				previous();
			}
		});

		Box box = new Box(BoxLayout.Y_AXIS);
		box.add(uplabel);
		box.add(Box.createVerticalStrut(6));
		box.add(downlabel);

		textlabel=new JTextField("");
		textlabel.setHorizontalAlignment(SwingConstants.LEFT);
		textlabel.setBorder(BorderFactory.createEmptyBorder());
		// no border for textfield
		textlabel.setMaximumSize(new Dimension(20, 20));
		textlabel.setMinimumSize(new Dimension(20, 10));
		textlabel.setPreferredSize(new Dimension(20, 16));
		textlabel.setColumns(2);
		textlabel.setEditable(false);
		textlabel.setOpaque(false);

		add(box, BorderLayout.EAST);

		this.add(textlabel, BorderLayout.CENTER);
	}

	/**
	 * Gets the current displayed data-item.
	 */
	public String getSelected() {
		return textlabel.getText();
	}
	
	/**
	 * Gets the inde of the curent displayed data-item.
	 */
	public int getSelectedIndex(){
		return selection;
	}
	/**
	 * Show next item in list
	 */
	public void next() {
		if (dataset) {
			int oldNr = selection;

			if (++selection < data.length)
				textlabel.setText(data[selection]);
			else {
				textlabel.setText(data[0]);
				selection = 0;
			}
//			this.firePropertyChange("loopToShow", data[oldNr], data[selection]);
			oldNr = selection;
			
			//inform the listener
			IteratorListener listener;
			for(int i=0;i<iterlistener.size();i++){
				listener=getIteratorListener(i);
				listener.iterationChanged(data[selection], selection);
			}
		}
	}

	/**
	 * Show previous item in list
	 */

	public void previous() {
		if (dataset) {
			int oldNr = selection;
				
			if (--selection >= 0) {
				textlabel.setText(data[selection]);
			} else {
				selection = data.length - 1;
				textlabel.setText(data[selection]);
			}
//			this.firePropertyChange("loopToShow", data[oldNr], data[selection]);
			oldNr = selection;

			//inform the listener
			IteratorListener listener;
			for(int i=0;i<iterlistener.size();i++){
				listener=getIteratorListener(i);
				listener.iterationChanged(data[selection], selection);
			}
		}
	}
}
/*
$Log: IteratorList.java,v $
Revision 1.3  2006/04/11 14:10:16  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:27  hakenjos
Initial version!

*/
