/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.musoft.limo.application.Resource;

/**
 * A dialog to delete a case.
 * @author Daniel Hakenjos
 * @version $Id: DeleteCaseDialog.java,v 1.3 2006/04/11 14:10:16 euler Exp $
 */
public class DeleteCaseDialog extends JDialog implements ActionListener, ListSelectionListener{

	public static final int CANCEL=0;
	public static final int DELETE=1;

	private MiningMartApplication app;

	private JList list;
	private JButton cancel, select;
	private int exitAction;
	

	/**
	 * Constructor for <code>DeleteCaseDialog</code>.
	 */
	public DeleteCaseDialog(MiningMartApplication parent) {
		super(parent, Resource.getString("DELETE_CASE"), true);
		
		this.app=parent;
		this.exitAction=CANCEL;	
		initComponents();
		this.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		
		this.pack();

		setSize(300,300);

		Dimension size=this.getSize();

		this.setLocation(
        (Toolkit.getDefaultToolkit().getScreenSize().width-
         size.width) / 2,
        (Toolkit.getDefaultToolkit().getScreenSize().height-
         size.height) / 2);
		this.setVisible(true);
	}

	/**
	 * Implementierung von Selection-Sort.
	 * 
	 */
	private String[] selectionSort(String[] data) {
		for (int i = 0; i < data.length - 1; i++) {
			// Erstes minimales Element in (a[i],...,a[n-1]) finden ...
			int min = i; // Position des aktuellen minimalen Elements
			for (int j = i + 1; j < data.length; j++)
				if (data[j].compareTo(data[min]) < 0)
					min = j;
			// ... und mit a[i] vertauschen:
			swap(data, min, i);
		}
		return data;
	}

	/** Hilfsmethode zur Vertauschung der Array-Elemente a[i] und a[j]. 
	  * Wir setzen 0 &le;= i, j &le; a.length voraus. 
	  */
	private void swap(Comparable[] a, int i, int j) {
		Comparable tmp = a[i];
		a[i] = a[j];
		a[j] = tmp;
	}

	
	public void initComponents(){
		
		JPanel top_panel=new JPanel();
		top_panel.setLayout(new BorderLayout(5,5));
		
		list=new JList();
		list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		list.setLayoutOrientation(JList.VERTICAL);
		list.setVisibleRowCount(-1);
		
		Collection coll=MiningMartApplication.m4Interface.getAllCaseNames();
		Iterator iter=coll.iterator();
		String one_case;
		String[] data=new String[coll.size()];
		int index=0;
		while (iter.hasNext()){
			//one_case=(String) iter.next();
			data[index]=(String) iter.next();
			index++;
		}
		
		data=selectionSort(data);
		
		list.setListData(data);
		list.addListSelectionListener(this);

		JScrollPane scrollpane=new JScrollPane(list);

		JPanel mid_panel=new JPanel();
		mid_panel.setLayout(new BorderLayout());
		
		mid_panel.add(scrollpane,BorderLayout.CENTER);
		
		top_panel.add(mid_panel,BorderLayout.CENTER);
		
		
		cancel=new JButton(Resource.getString("CANCEL"));
		select=new JButton(Resource.getString("DELETE"));
		select.setEnabled(false);
		
		cancel.addActionListener(this);
		select.addActionListener(this);
		
		JPanel bottom=new JPanel();
		bottom.setLayout(new BoxLayout(bottom, BoxLayout.X_AXIS));
		bottom.add(Box.createHorizontalGlue());
		bottom.add(select);
		bottom.add(Box.createRigidArea(new Dimension(10, 0)));
		bottom.add(cancel);
		
		top_panel.add(bottom,BorderLayout.SOUTH);
		
		JLabel label=new JLabel(Resource.getString("CASES")+":");
		
		top_panel.add(label,BorderLayout.NORTH);
	
		top_panel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		this.getContentPane().add(top_panel);
	}
	
	public void actionPerformed(ActionEvent e){
		String cmd=e.getActionCommand();
		
		if (cmd.equals(Resource.getString("CANCEL"))){
			exitAction=CANCEL;
			this.dispose();
		}
		if (cmd.equals(Resource.getString("DELETE"))){
			exitAction=DELETE;
			this.dispose();
		}
	}
	
	public void valueChanged(ListSelectionEvent e){
		if (!list.isSelectionEmpty()){
			select.setEnabled(true);
		}
	}

	/**
	 * Gets the ecit action.
	 * @see #DELETE
	 * @see #CANCEL
	 */
	public int getExitAction(){
		return exitAction;
	}

	/**
	 * Gets the selected name of the case to delete.	
	 */
	public String getSelectedCase(){
		if (exitAction==DELETE)
			return (String) list.getSelectedValue();
		return null;
	}


}
/*
$Log: DeleteCaseDialog.java,v $
Revision 1.3  2006/04/11 14:10:16  euler
Updated license text.

Revision 1.2  2006/04/06 16:31:15  euler
Prepended license remark.

Revision 1.1  2006/01/03 09:54:26  hakenjos
Initial version!

*/
