/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.gui.application;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.musoft.limo.application.Resource;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;

/**
 * A dialog for creating a new case.
 * The user must specify  the name and the mode of the new case.
 * @author Daniel Hakenjos
 * @version $Id: CreateCaseDialog.java,v 1.3 2006/04/11 14:10:16 euler Exp $
 */
public class CreateCaseDialog extends JDialog {

	private GridBagLayout gridBagLayout1 = new GridBagLayout();
	private JLabel caseLabel = new JLabel();
	private JTextField caseName = new JTextField("", 15);
	private JLabel modeLabel = new JLabel();
	private JCheckBox trainingCheckBox = new JCheckBox();
	private JCheckBox finalCheckBox = new JCheckBox();
	private JButton createButton = new JButton();
	private JButton cancelButton = new JButton();

	private Case caseToCreate = null;
	private boolean rename = false;
	private Case caseToRename = null;

	private MiningMartApplication app;

	/**
	 * Constructs new <code>CreateCaseDialog</code>.
	 */
	public CreateCaseDialog(
		MiningMartApplication app,
		String title,
		boolean modal) {
		super(app, title, modal);
		this.app = app;
		try {
			initComponents();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	private void initComponents() throws Exception {
		caseLabel.setText(Resource.getString("CASE_NAME"));
		this.getContentPane().setLayout(gridBagLayout1);
		modeLabel.setText(Resource.getString("CASE_MODE"));
		trainingCheckBox.setText(Resource.getString("CASE_MODE_TEST"));
		trainingCheckBox.setSelected(true);
		trainingCheckBox
			.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				checkBox_actionPerformed(e);
			}
		});
		finalCheckBox.setText(Resource.getString("CASE_MODE_FINAL"));
		finalCheckBox.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				checkBox_actionPerformed(e);
			}
		});
		createButton.setText(Resource.getString("OK"));
		createButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				createButton_actionPerformed(e);
			}
		});
		cancelButton.setText(Resource.getString("CANCEL"));
		cancelButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(ActionEvent e) {
				cancelButton_actionPerformed(e);
			}
		});
		JPanel panel = new JPanel();
		panel.setLayout(gridBagLayout1);
		panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		panel.add(
			caseLabel,
			new GridBagConstraints(
				0,
				0,
				1,
				1,
				0.0,
				0.0,
				GridBagConstraints.CENTER,
				GridBagConstraints.NONE,
				new Insets(0, 0, 10, 0),
				0,
				0));
		panel.add(
			caseName,
			new GridBagConstraints(
				1,
				0,
				1,
				1,
				0.0,
				0.0,
				GridBagConstraints.WEST,
				GridBagConstraints.NONE,
				new Insets(0, 0, 10, 0),
				0,
				0));
		panel.add(
			modeLabel,
			new GridBagConstraints(
				0,
				1,
				1,
				1,
				0.0,
				0.0,
				GridBagConstraints.CENTER,
				GridBagConstraints.NONE,
				new Insets(0, 0, 0, 0),
				0,
				0));
		panel.add(
			finalCheckBox,
			new GridBagConstraints(
				1,
				2,
				1,
				1,
				0.0,
				0.0,
				GridBagConstraints.WEST,
				GridBagConstraints.NONE,
				new Insets(0, 0, 0, 0),
				0,
				0));
		panel.add(
			createButton,
			new GridBagConstraints(
				0,
				3,
				1,
				1,
				0.0,
				0.0,
				GridBagConstraints.EAST,
				GridBagConstraints.NONE,
				new Insets(10, 0, 0, 5),
				0,
				0));
		panel.add(
			cancelButton,
			new GridBagConstraints(
				1,
				3,
				1,
				1,
				0.0,
				0.0,
				GridBagConstraints.WEST,
				GridBagConstraints.NONE,
				new Insets(10, 0, 0, 0),
				0,
				0));
		panel.add(
			trainingCheckBox,
			new GridBagConstraints(
				1,
				1,
				1,
				1,
				0.0,
				0.0,
				GridBagConstraints.WEST,
				GridBagConstraints.NONE,
				new Insets(0, 0, 0, 0),
				0,
				0));
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(panel, BorderLayout.CENTER);

		pack();
		setLocationRelativeTo(getRootPane());
	}

	/**
	 * Shows the dialog.
	 */
	public Case showCreateDialog() {
		rename = false;
		setVisible(true);
		return caseToCreate;
	}
	
	/**
	 * Shows the dialog for renaming the case.
	 */
	public Case showCreateDialog(Case c) {
		rename = true;
		caseToRename = c;
		caseName.setText(caseToRename.getName());
		finalCheckBox.setSelected(caseToRename.getTheMode().equals("final"));
		trainingCheckBox.setSelected(
			!caseToRename.getTheMode().equals("final"));
		setVisible(true);
		return caseToRename;
	}

	private void createButton_actionPerformed(ActionEvent e) {
		try {
			if (!rename) {
				boolean setAsCurrentCase = true;
				caseToCreate = MiningMartApplication.m4Interface.createCase(caseName.getText(), setAsCurrentCase);
				if (finalCheckBox.isSelected())
					caseToCreate.setTheMode("FINAL");
				else
					caseToCreate.setTheMode("TEST");
				caseToCreate.store();
			} else {
				caseToRename.setName(caseName.getText());
				if (finalCheckBox.isSelected())
					caseToRename.setTheMode("FINAL");
				else
					caseToRename.setTheMode("TEST");
			}
		} catch (M4Exception ex) {
			M4Interface.print.doPrint(Print.ERROR,ex.getMessage(),ex);
			JOptionPane.showMessageDialog(
				this,
				ex.getMessage(),
				Resource.getString("DIALOG_ERROR_TITLE"),
				JOptionPane.ERROR_MESSAGE);
			return;
		}

		dispose();
	}

	private void cancelButton_actionPerformed(ActionEvent e) {
		caseToCreate = null;
		dispose();
	}

	private void checkBox_actionPerformed(ActionEvent e) {
		if (e.getSource() == trainingCheckBox) {
			trainingCheckBox.setSelected(true);
			finalCheckBox.setSelected(false);
		} else {
			trainingCheckBox.setSelected(false);
			finalCheckBox.setSelected(true);
		}
	}

}
/*
 * Historie
 * --------
 *
 * $Log: CreateCaseDialog.java,v $
 * Revision 1.3  2006/04/11 14:10:16  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:15  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:27  hakenjos
 * Initial version!
 *
 */
