/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.exception;

import java.util.Collection;
import java.util.Vector;

import edu.udo.cs.miningmart.m4.OpParam;

/**
 * This Exception is thrown if, after removing Features deselected by automatic
 * FeatureConstruction, constraints on the number of parameters are violated.
 * 
 * @see edu.udo.cs.miningmart.m4.core.exception.ParameterError
 * 
 * @author Martin Scholz
 * @version $Id: ParameterDeselectedError.java,v 1.3 2006/04/11 14:10:15 euler Exp $
 */
public class ParameterDeselectedError extends ParameterError {
	
	/** Stores violated <code>OpParam</code>-objects. */
	final private Vector parameterProblems;
	
	/**
	 * Constructor.
	 * 
	 * @param errorMsg a message for the user
	 * @param op the <code>OpParam</code> object violated
	 */
	public ParameterDeselectedError(String errorMsg, OpParam op) {
		super(errorMsg);
		this.parameterProblems = new Vector();
		this.parameterProblems.add(op);
	}

	/**
	 * To concatenate <code>ParameterDeselectedError</code>s, plaese use this constructor.
	 * 
	 * @param errorMsg a message just for the current violation to be added to the last message(s)
	 * @param op the <code>OpParam</code> object currently signalled to be violated
	 * @param lastEx the last <code>ParameterDeselectedError</code> thrown for the same operator
	 *        application
	 */
	public ParameterDeselectedError(String errorMsg, OpParam op, ParameterDeselectedError lastEx) {
		super(lastEx.getMessage() + ";\n" + errorMsg);
		this.parameterProblems = new Vector(lastEx.getViolatedOpParams());
		this.parameterProblems.add(op);
	}
	
	/** 
	 * Getter method.
	 * 
	 * @return a <code>Collection</code> of <code>OpParam</code> objects, which were found to be
	 *         violated after removing deselected features.
	 */
	public Collection getViolatedOpParams() {
		return (Collection) this.parameterProblems.clone();
	}

}
/*
 * Historie
 * --------
 *
 * $Log: ParameterDeselectedError.java,v $
 * Revision 1.3  2006/04/11 14:10:15  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:14  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:37  hakenjos
 * Initial version!
 *
 */
