/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.db;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/**
 * Sort of a wrapper class for the database-specific
 * implementation of <code>java.sql.ResultSet</code>.
 * Offers the additional boolean method <code>isClosed()</code>.
 * 
 * @author Timm Euler
 * @version $Id: ExtendedResultSet.java,v 1.3 2006/04/11 14:10:16 euler Exp $
 */
class ExtendedResultSet implements ResultSet, Serializable
{
	private ResultSet myRS;
	private boolean isClosed;
	private Statement myStatement;
	
	/**
	 * Constructor for ExtendedResultSet.
	 */
	public ExtendedResultSet(ResultSet normalResultSet)
	{
		myRS = normalResultSet;
		isClosed = false;
		
		// myStatement = myRS.getStatement();
	}
	
	public ExtendedResultSet(Statement theStatement)
	{
		myRS = null;
		isClosed = true;
		myStatement = theStatement;
	}	

	/**
	 * @see java.sql.ResultSet#next()
	 */
	public boolean next() throws SQLException
	{
		return myRS.next();
	}

	/**
	 * @see java.sql.ResultSet#close()
	 */
	public void close() throws SQLException
	{
		if (myRS != null)
		{   myRS.close();   }
		myRS = null;
		isClosed = true;
	}
	
	/**
	 * @return TRUE iff this extended ResultSet had been closed.
	 */
	public boolean isClosed()
	{
		return isClosed;
	}
	
	/**
	 * @see java.sql.ResultSet#wasNull()
	 */
	public boolean wasNull() throws SQLException
	{
		return myRS.wasNull();
	}

	/**
	 * @see java.sql.ResultSet#getString(int)
	 */
	public String getString(int columnIndex) throws SQLException
	{
		return myRS.getString(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getBoolean(int)
	 */
	public boolean getBoolean(int columnIndex) throws SQLException
	{
		return myRS.getBoolean(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getByte(int)
	 */
	public byte getByte(int columnIndex) throws SQLException
	{
		return myRS.getByte(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getShort(int)
	 */
	public short getShort(int columnIndex) throws SQLException
	{
		return myRS.getShort(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getInt(int)
	 */
	public int getInt(int columnIndex) throws SQLException
	{
		return myRS.getInt(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getLong(int)
	 */
	public long getLong(int columnIndex) throws SQLException
	{
		return myRS.getLong(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getFloat(int)
	 */
	public float getFloat(int columnIndex) throws SQLException
	{
		return myRS.getFloat(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getDouble(int)
	 */
	public double getDouble(int columnIndex) throws SQLException
	{
		return myRS.getDouble(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getBigDecimal(int, int)
	 * @deprecated
	 */
	public BigDecimal getBigDecimal(int columnIndex, int scale)
		throws SQLException
	{
		// ignore the second Argument (scale) because the corresponding
		// method in java.sql.ResultSet is deprecated!
		return myRS.getBigDecimal(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getBytes(int)
	 */
	public byte[] getBytes(int columnIndex) throws SQLException
	{
		return myRS.getBytes(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getDate(int)
	 */
	public Date getDate(int columnIndex) throws SQLException
	{
		return myRS.getDate(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getTime(int)
	 */
	public Time getTime(int columnIndex) throws SQLException
	{
		return myRS.getTime(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getTimestamp(int)
	 */
	public Timestamp getTimestamp(int columnIndex) throws SQLException
	{
		return myRS.getTimestamp(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getAsciiStream(int)
	 */
	public InputStream getAsciiStream(int columnIndex) throws SQLException
	{
		return myRS.getAsciiStream(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getUnicodeStream(int)
	 * @deprecated
	 */
	public InputStream getUnicodeStream(int columnIndex) throws SQLException
	{
		throw new SQLException("Deprecated method used: ResultSet.getUnicodeStream(String)");
		// return myRS.getUnicodeStream(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getBinaryStream(int)
	 */
	public InputStream getBinaryStream(int columnIndex) throws SQLException
	{
		return myRS.getBinaryStream(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getString(String)
	 */
	public String getString(String columnName) throws SQLException
	{
		return myRS.getString(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getBoolean(String)
	 */
	public boolean getBoolean(String columnName) throws SQLException
	{
		return myRS.getBoolean(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getByte(String)
	 */
	public byte getByte(String columnName) throws SQLException
	{
		return myRS.getByte(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getShort(String)
	 */
	public short getShort(String columnName) throws SQLException
	{
		return myRS.getShort(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getInt(String)
	 */
	public int getInt(String columnName) throws SQLException
	{
		return myRS.getInt(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getLong(String)
	 */
	public long getLong(String columnName) throws SQLException
	{
		return myRS.getLong(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getFloat(String)
	 */
	public float getFloat(String columnName) throws SQLException
	{
		return myRS.getFloat(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getDouble(String)
	 */
	public double getDouble(String columnName) throws SQLException
	{
		return myRS.getDouble(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getBigDecimal(String, int)
	 * @deprecated
	 */
	public BigDecimal getBigDecimal(String columnName, int scale)
		throws SQLException
	{
		// ignore the second Argument (scale) because the corresponding
		// method in java.sql.ResultSet is deprecated!
		return myRS.getBigDecimal(columnName);	
	}

	/**
	 * @see java.sql.ResultSet#getBytes(String)
	 */
	public byte[] getBytes(String columnName) throws SQLException
	{
		return myRS.getBytes(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getDate(String)
	 */
	public Date getDate(String columnName) throws SQLException
	{
		return myRS.getDate(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getTime(String)
	 */
	public Time getTime(String columnName) throws SQLException
	{
		return myRS.getTime(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getTimestamp(String)
	 */
	public Timestamp getTimestamp(String columnName) throws SQLException
	{
		return myRS.getTimestamp(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getAsciiStream(String)
	 */
	public InputStream getAsciiStream(String columnName) throws SQLException
	{
		return myRS.getAsciiStream(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getUnicodeStream(String)
	 * @deprecated
	 */
	public InputStream getUnicodeStream(String columnName) throws SQLException
	{
		throw new SQLException("Deprecated method used: ResultSet.getUnicodeStream(String)");
		// return myRS.getUnicodeStream(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getBinaryStream(String)
	 */
	public InputStream getBinaryStream(String columnName) throws SQLException
	{
		return myRS.getBinaryStream(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getWarnings()
	 */
	public SQLWarning getWarnings() throws SQLException
	{
		return myRS.getWarnings();
	}

	/**
	 * @see java.sql.ResultSet#clearWarnings()
	 */
	public void clearWarnings() throws SQLException
	{
		myRS.clearWarnings();
	}

	/**
	 * @see java.sql.ResultSet#getCursorName()
	 */
	public String getCursorName() throws SQLException
	{
		return myRS.getCursorName();
	}

	/**
	 * @see java.sql.ResultSet#getMetaData()
	 */
	public ResultSetMetaData getMetaData() throws SQLException
	{
		return myRS.getMetaData();
	}

	/**
	 * @see java.sql.ResultSet#getObject(int)
	 */
	public Object getObject(int columnIndex) throws SQLException
	{
		return myRS.getObject(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getObject(String)
	 */
	public Object getObject(String columnName) throws SQLException
	{
		return myRS.getObject(columnName);
	}

	/**
	 * @see java.sql.ResultSet#findColumn(String)
	 */
	public int findColumn(String columnName) throws SQLException
	{
		return myRS.findColumn(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getCharacterStream(int)
	 */
	public Reader getCharacterStream(int columnIndex) throws SQLException
	{
		return myRS.getCharacterStream(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getCharacterStream(String)
	 */
	public Reader getCharacterStream(String columnName) throws SQLException
	{
		return myRS.getCharacterStream(columnName);
	}

	/**
	 * @see java.sql.ResultSet#getBigDecimal(int)
	 */
	public BigDecimal getBigDecimal(int columnIndex) throws SQLException
	{
		return myRS.getBigDecimal(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getBigDecimal(String)
	 */
	public BigDecimal getBigDecimal(String columnName) throws SQLException
	{
		return myRS.getBigDecimal(columnName);
	}

	/**
	 * @see java.sql.ResultSet#isBeforeFirst()
	 */
	public boolean isBeforeFirst() throws SQLException
	{
		return myRS.isBeforeFirst();
	}

	/**
	 * @see java.sql.ResultSet#isAfterLast()
	 */
	public boolean isAfterLast() throws SQLException
	{
		return myRS.isAfterLast();
	}

	/**
	 * @see java.sql.ResultSet#isFirst()
	 */
	public boolean isFirst() throws SQLException
	{
		return myRS.isFirst();
	}

	/**
	 * @see java.sql.ResultSet#isLast()
	 */
	public boolean isLast() throws SQLException
	{
		return myRS.isLast();
	}

	/**
	 * @see java.sql.ResultSet#beforeFirst()
	 */
	public void beforeFirst() throws SQLException
	{
		myRS.beforeFirst();
	}

	/**
	 * @see java.sql.ResultSet#afterLast()
	 */
	public void afterLast() throws SQLException
	{
		myRS.afterLast();
	}

	/**
	 * @see java.sql.ResultSet#first()
	 */
	public boolean first() throws SQLException
	{
		return myRS.first();
	}

	/**
	 * @see java.sql.ResultSet#last()
	 */
	public boolean last() throws SQLException
	{
		return myRS.last();
	}

	/**
	 * @see java.sql.ResultSet#getRow()
	 */
	public int getRow() throws SQLException
	{
		return myRS.getRow();
	}

	/**
	 * @see java.sql.ResultSet#absolute(int)
	 */
	public boolean absolute(int row) throws SQLException
	{
		return myRS.absolute(row);
	}

	/**
	 * @see java.sql.ResultSet#relative(int)
	 */
	public boolean relative(int rows) throws SQLException
	{
		return myRS.relative(rows);
	}

	/**
	 * @see java.sql.ResultSet#previous()
	 */
	public boolean previous() throws SQLException
	{
		return myRS.previous();
	}

	/**
	 * @see java.sql.ResultSet#setFetchDirection(int)
	 */
	public void setFetchDirection(int direction) throws SQLException
	{
		myRS.setFetchDirection(direction);
	}

	/**
	 * @see java.sql.ResultSet#getFetchDirection()
	 */
	public int getFetchDirection() throws SQLException
	{
		return myRS.getFetchDirection();
	}

	/**
	 * @see java.sql.ResultSet#setFetchSize(int)
	 */
	public void setFetchSize(int rows) throws SQLException
	{
	}

	/**
	 * @see java.sql.ResultSet#getFetchSize()
	 */
	public int getFetchSize() throws SQLException
	{
		return myRS.getFetchSize();
	}

	/**
	 * @see java.sql.ResultSet#getType()
	 */
	public int getType() throws SQLException
	{
		return myRS.getType();
	}

	/**
	 * @see java.sql.ResultSet#getConcurrency()
	 */
	public int getConcurrency() throws SQLException
	{
		return myRS.getConcurrency();
	}

	/**
	 * @see java.sql.ResultSet#rowUpdated()
	 */
	public boolean rowUpdated() throws SQLException
	{
		return myRS.rowUpdated();
	}

	/**
	 * @see java.sql.ResultSet#rowInserted()
	 */
	public boolean rowInserted() throws SQLException
	{
		return myRS.rowInserted();
	}

	/**
	 * @see java.sql.ResultSet#rowDeleted()
	 */
	public boolean rowDeleted() throws SQLException
	{
		return myRS.rowDeleted();
	}

	/**
	 * @see java.sql.ResultSet#updateNull(int)
	 */
	public void updateNull(int columnIndex) throws SQLException
	{
		myRS.updateNull(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#updateBoolean(int, boolean)
	 */
	public void updateBoolean(int columnIndex, boolean x) throws SQLException
	{
		myRS.updateBoolean(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateByte(int, byte)
	 */
	public void updateByte(int columnIndex, byte x) throws SQLException
	{
		myRS.updateByte(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateShort(int, short)
	 */
	public void updateShort(int columnIndex, short x) throws SQLException
	{
		myRS.updateShort(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateInt(int, int)
	 */
	public void updateInt(int columnIndex, int x) throws SQLException
	{
		myRS.updateInt(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateLong(int, long)
	 */
	public void updateLong(int columnIndex, long x) throws SQLException
	{
		myRS.updateLong(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateFloat(int, float)
	 */
	public void updateFloat(int columnIndex, float x) throws SQLException
	{
		myRS.updateFloat(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateDouble(int, double)
	 */
	public void updateDouble(int columnIndex, double x) throws SQLException
	{
		myRS.updateDouble(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateBigDecimal(int, BigDecimal)
	 */
	public void updateBigDecimal(int columnIndex, BigDecimal x)
		throws SQLException
	{
		myRS.updateBigDecimal(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateString(int, String)
	 */
	public void updateString(int columnIndex, String x) throws SQLException
	{
		myRS.updateString(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateBytes(int, byte[])
	 */
	public void updateBytes(int columnIndex, byte[] x) throws SQLException
	{
		myRS.updateBytes(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateDate(int, Date)
	 */
	public void updateDate(int columnIndex, Date x) throws SQLException
	{
		myRS.updateDate(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateTime(int, Time)
	 */
	public void updateTime(int columnIndex, Time x) throws SQLException
	{
		myRS.updateTime(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateTimestamp(int, Timestamp)
	 */
	public void updateTimestamp(int columnIndex, Timestamp x)
		throws SQLException
	{
		myRS.updateTimestamp(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateAsciiStream(int, InputStream, int)
	 */
	public void updateAsciiStream(int columnIndex, InputStream x, int length)
		throws SQLException
	{
		myRS.updateAsciiStream(columnIndex, x, length);
	}

	/**
	 * @see java.sql.ResultSet#updateBinaryStream(int, InputStream, int)
	 */
	public void updateBinaryStream(int columnIndex, InputStream x, int length)
		throws SQLException
	{
		myRS.updateBinaryStream(columnIndex, x, length);
	}

	/**
	 * @see java.sql.ResultSet#updateCharacterStream(int, Reader, int)
	 */
	public void updateCharacterStream(int columnIndex, Reader x, int length)
		throws SQLException
	{
		myRS.updateCharacterStream(columnIndex, x, length);
	}

	/**
	 * @see java.sql.ResultSet#updateObject(int, Object, int)
	 */
	public void updateObject(int columnIndex, Object x, int scale)
		throws SQLException
	{
		myRS.updateObject(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateObject(int, Object)
	 */
	public void updateObject(int columnIndex, Object x) throws SQLException
	{
		myRS.updateObject(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateNull(String)
	 */
	public void updateNull(String columnName) throws SQLException
	{
	        myRS.updateNull(columnName);
	}

	/**
	 * @see java.sql.ResultSet#updateBoolean(String, boolean)
	 */
	public void updateBoolean(String columnName, boolean x) throws SQLException
	{
	        myRS.updateBoolean(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateByte(String, byte)
	 */
	public void updateByte(String columnName, byte x) throws SQLException
	{
	        myRS.updateByte(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateShort(String, short)
	 */
	public void updateShort(String columnName, short x) throws SQLException
	{
	        myRS.updateShort(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateInt(String, int)
	 */
	public void updateInt(String columnName, int x) throws SQLException
	{
	        myRS.updateInt(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateLong(String, long)
	 */
	public void updateLong(String columnName, long x) throws SQLException
	{
	        myRS.updateLong(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateFloat(String, float)
	 */
	public void updateFloat(String columnName, float x) throws SQLException
	{
	        myRS.updateFloat(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateDouble(String, double)
	 */
	public void updateDouble(String columnName, double x) throws SQLException
	{
	        myRS.updateDouble(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateBigDecimal(String, BigDecimal)
	 */
	public void updateBigDecimal(String columnName, BigDecimal x)
		throws SQLException
	{
	        myRS.updateBigDecimal(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateString(String, String)
	 */
	public void updateString(String columnName, String x) throws SQLException
	{
	        myRS.updateString(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateBytes(String, byte[])
	 */
	public void updateBytes(String columnName, byte[] x) throws SQLException
	{
	        myRS.updateBytes(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateDate(String, Date)
	 */
	public void updateDate(String columnName, Date x) throws SQLException
	{
	        myRS.updateDate(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateTime(String, Time)
	 */
	public void updateTime(String columnName, Time x) throws SQLException
	{
	        myRS.updateTime(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateTimestamp(String, Timestamp)
	 */
	public void updateTimestamp(String columnName, Timestamp x)
		throws SQLException
	{
	        myRS.updateTimestamp(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateAsciiStream(String, InputStream, int)
	 */
	public void updateAsciiStream(String columnName, InputStream x, int length)
		throws SQLException
	{
	        myRS.updateAsciiStream(columnName, x, length);
	}

	/**
	 * @see java.sql.ResultSet#updateBinaryStream(String, InputStream, int)
	 */
	public void updateBinaryStream(
		String columnName,
		InputStream x,
		int length)
		throws SQLException
	{
	    myRS.updateBinaryStream(columnName, x, length);
	}

	/**
	 * @see java.sql.ResultSet#updateCharacterStream(String, Reader, int)
	 */
	public void updateCharacterStream(
		String columnName,
		Reader reader,
		int length)
		throws SQLException
	{
	    myRS.updateCharacterStream(columnName, reader, length);
	}

	/**
	 * @see java.sql.ResultSet#updateObject(String, Object, int)
	 */
	public void updateObject(String columnName, Object x, int scale)
		throws SQLException
	{
	    myRS.updateObject(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateObject(String, Object)
	 */
	public void updateObject(String columnName, Object x) throws SQLException
	{
	    myRS.updateObject(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#insertRow()
	 */
	public void insertRow() throws SQLException
	{
		myRS.insertRow();
	}

	/**
	 * @see java.sql.ResultSet#updateRow()
	 */
	public void updateRow() throws SQLException
	{
		myRS.updateRow();
	}

	/**
	 * @see java.sql.ResultSet#deleteRow()
	 */
	public void deleteRow() throws SQLException
	{
		myRS.deleteRow();
	}

	/**
	 * @see java.sql.ResultSet#refreshRow()
	 */
	public void refreshRow() throws SQLException
	{
		myRS.refreshRow();
	}

	/**
	 * @see java.sql.ResultSet#cancelRowUpdates()
	 */
	public void cancelRowUpdates() throws SQLException
	{
		myRS.cancelRowUpdates();
	}

	/**
	 * @see java.sql.ResultSet#moveToInsertRow()
	 */
	public void moveToInsertRow() throws SQLException
	{
		myRS.moveToInsertRow();
	}

	/**
	 * @see java.sql.ResultSet#moveToCurrentRow()
	 */
	public void moveToCurrentRow() throws SQLException
	{
		myRS.moveToCurrentRow();
	}

	/**
	 * @see java.sql.ResultSet#getStatement()
	 */
	public Statement getStatement() throws SQLException
	{
		return myRS.getStatement();
	}

	/**
	 * @see java.sql.ResultSet#getObject(int, Map)
	 */
	public Object getObject(int i, Map map) throws SQLException
	{
		return myRS.getObject(i, map);
	}

	/**
	 * @see java.sql.ResultSet#getRef(int)
	 */
	public Ref getRef(int i) throws SQLException
	{
		return myRS.getRef(i);
	}

	/**
	 * @see java.sql.ResultSet#getBlob(int)
	 */
	public Blob getBlob(int i) throws SQLException
	{
		return myRS.getBlob(i);
	}

	/**
	 * @see java.sql.ResultSet#getClob(int)
	 */
	public Clob getClob(int i) throws SQLException
	{
		return myRS.getClob(i);
	}

	/**
	 * @see java.sql.ResultSet#getArray(int)
	 */
	public Array getArray(int i) throws SQLException
	{
		return myRS.getArray(i);
	}

	/**
	 * @see java.sql.ResultSet#getObject(String, Map)
	 */
	public Object getObject(String colName, Map map) throws SQLException
	{
		return myRS.getObject(colName, map);
	}

	/**
	 * @see java.sql.ResultSet#getRef(String)
	 */
	public Ref getRef(String colName) throws SQLException
	{
		return myRS.getRef(colName);
	}

	/**
	 * @see java.sql.ResultSet#getBlob(String)
	 */
	public Blob getBlob(String colName) throws SQLException
	{
		return myRS.getBlob(colName);
	}

	/**
	 * @see java.sql.ResultSet#getClob(String)
	 */
	public Clob getClob(String colName) throws SQLException
	{
		return myRS.getClob(colName);
	}

	/**
	 * @see java.sql.ResultSet#getArray(String)
	 */
	public Array getArray(String colName) throws SQLException
	{
		return myRS.getArray(colName);
	}

	/**
	 * @see java.sql.ResultSet#getDate(int, Calendar)
	 */
	public Date getDate(int columnIndex, Calendar cal) throws SQLException
	{
		return myRS.getDate(columnIndex, cal);
	}

	/**
	 * @see java.sql.ResultSet#getDate(String, Calendar)
	 */
	public Date getDate(String columnName, Calendar cal) throws SQLException
	{
		return myRS.getDate(columnName, cal);
	}

	/**
	 * @see java.sql.ResultSet#getTime(int, Calendar)
	 */
	public Time getTime(int columnIndex, Calendar cal) throws SQLException
	{
		return myRS.getTime(columnIndex, cal);
	}

	/**
	 * @see java.sql.ResultSet#getTime(String, Calendar)
	 */
	public Time getTime(String columnName, Calendar cal) throws SQLException
	{
		return myRS.getTime(columnName, cal);
	}

	/**
	 * @see java.sql.ResultSet#getTimestamp(int, Calendar)
	 */
	public Timestamp getTimestamp(int columnIndex, Calendar cal)
		throws SQLException
	{
		return myRS.getTimestamp(columnIndex, cal);
	}

	/**
	 * @see java.sql.ResultSet#getTimestamp(String, Calendar)
	 */
	public Timestamp getTimestamp(String columnName, Calendar cal)
		throws SQLException
	{
		return myRS.getTimestamp(columnName, cal);
	}

	/**
	 * @see java.sql.ResultSet#getURL(int)
	 */
	public URL getURL(int columnIndex) throws SQLException
	{
		return myRS.getURL(columnIndex);
	}

	/**
	 * @see java.sql.ResultSet#getURL(String)
	 */
	public URL getURL(String columnName) throws SQLException
	{
		return myRS.getURL(columnName);
	}

	/**
	 * @see java.sql.ResultSet#updateRef(int, Ref)
	 */
	public void updateRef(int columnIndex, Ref x) throws SQLException
	{
	    myRS.updateRef(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateRef(String, Ref)
	 */
	public void updateRef(String columnName, Ref x) throws SQLException
	{
	    myRS.updateRef(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateBlob(int, Blob)
	 */
	public void updateBlob(int columnIndex, Blob x) throws SQLException
	{
	    myRS.updateBlob(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateBlob(String, Blob)
	 */
	public void updateBlob(String columnName, Blob x) throws SQLException
	{
	    myRS.updateBlob(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateClob(int, Clob)
	 */
	public void updateClob(int columnIndex, Clob x) throws SQLException
	{
	    myRS.updateClob(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateClob(String, Clob)
	 */
	public void updateClob(String columnName, Clob x) throws SQLException
	{
	    myRS.updateClob(columnName, x);
	}

	/**
	 * @see java.sql.ResultSet#updateArray(int, Array)
	 */
	public void updateArray(int columnIndex, Array x) throws SQLException
	{
	    myRS.updateArray(columnIndex, x);
	}

	/**
	 * @see java.sql.ResultSet#updateArray(String, Array)
	 */
	public void updateArray(String columnName, Array x) throws SQLException
	{
	    myRS.updateArray(columnName, x);
	}
}
/*
 * Historie
 * --------
 *
 * $Log: ExtendedResultSet.java,v $
 * Revision 1.3  2006/04/11 14:10:16  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:15  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:22  hakenjos
 * Initial version!
 *
 */
