/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

import edu.udo.cs.miningmart.db.DB;

/**
 * @author Alessandro Serra
 * @version $Id: ToPLSql.java,v 1.4 2006/04/11 14:10:17 euler Exp $
 */
public class ToPLSql {
	protected String m_result_name;
	protected MetaData m_md;
	protected DB m4db;

	public ToPLSql() {
		m_result_name="result";
	}

	public DB getM4Db() {
		return this.m4db;	
	}

	public void setMetaData(MetaData md) {
		m_md=md;
	}
	public String getResultName() {
		return m_result_name;
	}
	public void setResultName(String s) {
		m_result_name=s;
	}
	public void setConnection(DB m4db) {
		this.m4db = m4db;
	}

	public void convertToFunctionOn(PrintWriter w, Object o) 
		throws Exception {
	}
	
	public void convert(Object o) throws Exception {
		StringWriter w = new StringWriter();
		PrintWriter pw = new PrintWriter(w);
		convertToFunctionOn(pw, o);
		pw.close();
		w.close();
		String query = new String(w.getBuffer());
		try {
			this.getM4Db().executeBusinessSqlWrite(query);
			this.getM4Db().commitBusinessTransactions();
		}
		catch(SQLException e) {
			throw new DMException(
				"Wrapper: Error tryning"+
				" to insert sql function:"+
				e.getMessage());
		} 
	}

	protected void printSpaceOn(PrintWriter w, int s) {
		int i;
		for(i=0; i<s; ++i) {
			w.print("\t");
		}
	}
	protected void printAttr(PrintWriter w, String a) {
		w.print(a);
	}

	protected void printFuncHeader(PrintWriter w) {
		w.print("CREATE OR REPLACE FUNCTION "+m_result_name+"_fct (\n");
		int col_num=m_md.getColumnInfos().size();
		int col_i;
		for(col_i=0; col_i<col_num; ++col_i) {
			ColumnInfo ci=(ColumnInfo)
				m_md.getColumnInfos().elementAt(col_i);
			w.print("\t"+ci.getName()+" "+ci.getDataTypeName());
			if(col_i!=col_num-1)
				w.print(",");
			w.print("\n");
		}
		w.print("	) RETURN ");
		if(m_md.getColumnToLearn()!=null) {
			ColumnInfo ci=(ColumnInfo)m_md.getColumnToLearn();
			w.print(ci.getDataTypeName());
		} else {
			w.print("STRING");
		}
		w.print(" IS \n");
		printFuncDeclaration(w);
		w.print("BEGIN \n");
	}
	protected void printFuncDeclaration(PrintWriter w) {
	}
	protected void printFuncTrailer(PrintWriter w) {
		w.print("END; \n");
	}
};
/*
 * Historie
 * --------
 * 
 * $Log: ToPLSql.java,v $
 * Revision 1.4  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:15  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */
