/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista;

import java.util.*;

/**
 * @author Alessandro Serra
 * @version $Id: MetaData.java,v 1.4 2006/04/11 14:10:17 euler Exp $
 */
public class MetaData {
	protected String m_table_name;
	protected Vector m_columns;
	protected ColumnInfo m_column_to_learn;

	public MetaData() {
		m_columns=new Vector();
	}
	
	final public String getTableName() {
		return m_table_name;
	}
	final public void setTableName(String n) {
		m_table_name=n;
	}
	final public ColumnInfo getColumnToLearn() {
		return m_column_to_learn;
	}
	final public void setColumnToLearn(ColumnInfo ci) {
		m_column_to_learn=ci;
	}
	final public Vector getColumnInfos() {
		return m_columns;
	}
	final public ColumnInfo findColumnInfo(String name) {
		int i;
		for(i=0; i<m_columns.size(); ++i) {
			if( ((ColumnInfo)(m_columns.elementAt(i)))
					.getName().equals(name)) {
				return (ColumnInfo)(m_columns.elementAt(i));
			}
		}
		return null;
	}
	final public void addColumnInfo(ColumnInfo ci) {
		m_columns.add(ci);
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: MetaData.java,v $
 * Revision 1.4  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:15  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */
