/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.MMS3;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import edu.udo.cs.miningmart.compiler.wrapper.dista.DLFTokenizer;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Attribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NominalAttribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NumericAttribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Schema;

/**
 * @author Alessandro Serra
 * @version $Id: CentersParser.java,v 1.3 2006/04/11 14:10:17 euler Exp $
 */
public class CentersParser 
{
   	DLFTokenizer m_st;
	Schema l_schema;

	public CentersParser(Reader r) {
   		m_st = new DLFTokenizer(r);
	}
	
	protected Attribute parseAttr() throws Exception {
		Attribute attr=null;
		String ty=m_st.getWord();
		if(ty.equals("nom")) {
			m_st.checkBeginRecord();
			attr=new NominalAttribute();
			attr.setName(m_st.getString());
			attr.setWeight(m_st.getNumber());
			m_st.checkEndRecord();
		} else if(ty.equals("num")) {
			m_st.checkBeginRecord();
			attr=new NumericAttribute();
			attr.setName(m_st.getString());
			attr.setWeight(m_st.getNumber());
			((NumericAttribute)attr).setMinValue(m_st.getNumber());
			((NumericAttribute)attr).setMaxValue(m_st.getNumber());
			m_st.checkEndRecord();
		} else {
			throw new Exception(m_st.errorMsg("expected nom/num words"));
		}
		return attr;
	}
	
	protected Center parseCenter() throws Exception {
		
		Center r=new Center(l_schema);
		m_st.checkBeginList();
		int i;
		for(i=0; i<l_schema.getAttributes().size(); ++i) 
		{
			Attribute attr=(Attribute)l_schema.getAttributes().elementAt(i);
			if(attr instanceof NumericAttribute) 
			{
				// NumericAttribute a=(NumericAttribute)attr;
				r.setValue(i,m_st.getNumericValue());
			} 
			else if (attr instanceof NominalAttribute) 
			     {
					// NominalAttribute a=(NominalAttribute)attr;
					r.setValue(i,m_st.getNominalValue());
				 } 
				 else throw new Exception(m_st.errorMsg("internal error: unknow attribute class"));
		}
		m_st.checkEndList();
		return r;
	}

	public Centers parse() throws Exception {
		Centers cs=new Centers();
		l_schema=new Schema();
		cs.setSchema(l_schema);
		m_st.nextToken();
		if(!m_st.getWord().equals("mms3")) {
			throw new Exception(m_st.errorMsg("expected mms3 word"));
		};
		m_st.checkBeginRecord();

		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			l_schema.addAttr(parseAttr());
		}
		
		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			cs.addCenter(parseCenter());
		}
		m_st.checkEndRecord();
		m_st.checkEOF();
		l_schema=null;
		return cs;
	}

	public static void main(String args[]) {
		Centers centers;
		try {
			Reader r = new BufferedReader(new FileReader(args[0]));
			CentersParser tp=new CentersParser(r);

			centers=tp.parse();
			
			Writer w= new BufferedWriter(new FileWriter(args[1]));
			PrintWriter pw=new PrintWriter(w);
			
			centers.dumpOn(pw);
			pw.close();
			w.close();	
			
		} catch(Exception e) {
			System.out.print(e+"\n");
		}
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: CentersParser.java,v $
 * Revision 1.3  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:16  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:40  hakenjos
 * Initial version!
 *
 */
