/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.FS;

import edu.udo.cs.miningmart.operator.ExecutableOperator;
import edu.udo.cs.miningmart.compiler.wrapper.dista.ColumnInfo;

import edu.udo.cs.miningmart.compiler.SystemPropertyInterface;
import edu.udo.cs.miningmart.m4.Step;

/**
 * @author Alessandro Serra, Timm Euler
 * @version $Id: StatisticalFeatureSelectionWrapper.java,v 1.4 2006/04/11 14:10:18 euler Exp $
 */
public class StatisticalFeatureSelectionWrapper extends FeatureSelectionWrapper {
	public double m_threshold;

	public StatisticalFeatureSelectionWrapper(Step step, ExecutableOperator exOp) throws Exception {
		super(step, exOp);
		m_threshold=0.7;
	}
	public void checkMetaData() throws Exception {
		int i;
		for(i=0; i<m_md.getColumnInfos().size(); ++i) {
			ColumnInfo ci=(ColumnInfo)
				m_md.getColumnInfos().elementAt(i);
			if(ci.getConceptType()==ColumnInfo.ORDINAL) {
				ci.setConceptType(ColumnInfo.CATEGORIAL);
			}
		}
	}
	protected void callTool() throws Exception {
		String temporaryDir = SystemPropertyInterface.getProperty(SystemPropertyInterface.NAME_MM_TEMP);

		// copy files:
		callScript("cp " + m_ml_home + "/etc/*.table " + temporaryDir);
			
		// call binary:
		callScript("fsstat -f" + m_file_name + " -o" + m_file_name +" -t" + m_threshold);
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: StatisticalFeatureSelectionWrapper.java,v $
 * Revision 1.4  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:34  hakenjos
 * Initial version!
 *
 */

