/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.FS;

import edu.udo.cs.miningmart.operator.ExecutableOperator;
import edu.udo.cs.miningmart.compiler.wrapper.dista.ColumnInfo;

import edu.udo.cs.miningmart.compiler.SystemPropertyInterface;
import edu.udo.cs.miningmart.m4.Step;

/**
 * @author Alessandro Serra, Timm Euler
 * @version $Id: GeneticFeatureSelectionWrapper.java,v 1.4 2006/04/11 14:10:18 euler Exp $
 */
public class GeneticFeatureSelectionWrapper extends FeatureSelectionWrapper {
	public int m_pop_size;
	public int m_gen_num;
	public double m_prob_mut;
	public double m_prob_cross;

	public GeneticFeatureSelectionWrapper(Step step, ExecutableOperator exOp) throws Exception {
		super(step, exOp);
		m_pop_size=30;
		m_gen_num=20;
		m_prob_mut=0.001;
		m_prob_cross=0.9;
	}
	public void checkMetaData() throws Exception {
		if(m_md.getColumnToLearn()==null) {
			throw new Exception("GeneticFeatureSelection is a supervised"+
				" learning algoritm."+
				" It require a column to learn");
		}
		// added option BINARY, T. Euler, 30.1.2003:
		if ((m_md.getColumnToLearn().getConceptType() != ColumnInfo.CATEGORIAL)
		    &&
		    (m_md.getColumnToLearn().getConceptType() != ColumnInfo.BINARY)) {
			throw new Exception("GeneticFeatureSelection is a supervised"+
				" learning algoritm."+
				" It requires a CATEGORIAL or BINARY column as target");
		}
		int i;
		for(i=0; i<m_md.getColumnInfos().size(); ++i) {
			ColumnInfo ci=(ColumnInfo)
				m_md.getColumnInfos().elementAt(i);
			if(ci.getConceptType()==ColumnInfo.ORDINAL) {
				ci.setConceptType(ColumnInfo.CATEGORIAL);
			}
		}
	}
	
	protected void callTool() throws Exception {
		String temporaryDir = SystemPropertyInterface.getProperty(SystemPropertyInterface.NAME_MM_TEMP);
		
		// copy files:
		callScript("cp " + m_ml_home + "/etc/*.table " + temporaryDir);
		
		// call genetic fs binary:
		callScript("fsgenetic -f" + m_file_name + " -o" + m_file_name +
			       " -l\"c4.5_fselect -f\" -p" + m_pop_size +
			       " -g" + m_gen_num + " -m" + m_prob_mut + " -x" + m_prob_cross);
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: GeneticFeatureSelectionWrapper.java,v $
 * Revision 1.4  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:34  hakenjos
 * Initial version!
 *
 */

