/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.FS;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;

import edu.udo.cs.miningmart.compiler.wrapper.dista.DLFTokenizer;

/**
 * @author Alessandro Serra
 * @version $Id: FeatureSelectionParser.java,v 1.4 2006/04/11 14:10:18 euler Exp $
 */
public class FeatureSelectionParser {
	DLFTokenizer m_st;
	
	public FeatureSelectionParser(Reader r) {
   		m_st = new DLFTokenizer(r);
	}
	protected String parseAttr() throws Exception {
		String ty=m_st.getWord();
		return ty;
	}
	public Vector parse() throws Exception {
		Vector v;
		v=new Vector();
		m_st.nextToken();
		m_st.checkBeginRecord();

		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			v.add(parseAttr());
		}
		if(!m_st.isEndRecord()) {
			m_st.checkBeginList();
			while(!m_st.isEndList()) {
				m_st.nextToken();
			}
			m_st.checkEndRecord();
			m_st.checkBeginRecord();
			m_st.checkBeginList();
			v=new Vector();
			while(!m_st.isEndList()) {
				v.add(parseAttr());
			}
			m_st.checkEndRecord();
			m_st.checkEOF();
		} else {
			m_st.checkEOF();
		}
		return v;
	}

	public static void main(String args[]) {
		Vector v;
		try {
			Reader r = new BufferedReader(new FileReader(args[0]));
			FeatureSelectionParser tp=new FeatureSelectionParser(r);

			v=tp.parse();
			
			Writer w= new BufferedWriter(new FileWriter(args[1]));
			PrintWriter pw=new PrintWriter(w);
			
			pw.print(v);
			pw.close();
			w.close();	
		} catch(Exception e) {
			System.out.print(e+"\n");
		}
	}
}

/*
 * Historie
 * --------
 * 
 * $Log: FeatureSelectionParser.java,v $
 * Revision 1.4  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:34  hakenjos
 * Initial version!
 *
 */

