/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista;

import java.util.Vector;

/**
 * 
 * @author Alessandro Serra, Timm Euler
 * @version $Id: ColumnInfo.java,v 1.4 2006/04/11 14:10:17 euler Exp $
 */
public class ColumnInfo {
	// concept type
	public static final int NOMINAL=0;
	public static final int CATEGORIAL=1;
	public static final int NUMERIC=2;
	public static final int ORDINAL=3;
	public static final int SCALAR=4;
	public static final int TIME=5;
	public static final int BINARY=6;

	// oracle type
	public static final int STRING=0;
 	public static final int DATE=1;
	public static final int NUMBER=2;

	protected String m_name;     // Column name
	protected String m_sql_name; // SQL definition
	protected int m_oracle_type;
	protected int m_concept_type;
	protected Vector m_values;

	public ColumnInfo() {
		m_values=new Vector();
	}

	/** @return the name of the M4 <code>Column</code> */
	final public String getName() {
		return m_name;
	}
	
	/** @return the SQL definition of the M4 <code>Column</code> */
	final public String getSqlName() {
		return m_sql_name;
	}

	/** @param n the name of the M4 <code>Column</code> */	
	final public void setName(String n) {
		m_name=n;
		if(m_sql_name==null) m_sql_name=m_name;
	}

	/** @param n the SQL definition of the M4 <code>Column</code> */
	final public void setSqlName(String n) {
		m_sql_name=n;
	}
	
	final public int getDataType() {
		return m_oracle_type;
	}
	
	final public int getConceptType() {
		return m_concept_type;
	}
	
	final public void setDataType(int v) {
		m_oracle_type=v;
	}
	
	final public void setConceptType(int v) {
		m_concept_type=v;
	}
	
	final public String getDataTypeName() {
		switch(m_oracle_type) {
			case STRING: 
				return "STRING";
			case DATE: 
				return "DATE";
			case NUMBER: 
				return "NUMBER";
			default:
				return "BO!!";
		}
	}
	
	final public void setDataType(String n) throws Exception {
		if(n.equals("STRING")) {
			m_oracle_type=STRING;
		} else if(n.equals("DATE")) {
			m_oracle_type=DATE;
		} else if(n.equals("NUMBER")) {
			m_oracle_type=NUMBER;
		} else {
			throw new Exception(n+" is an unknown relational datatype");
		}
	}
	
	final public void setConceptType(String n) throws Exception {
		if(n.equals("NOMINAL")) {
			m_concept_type=NOMINAL;
		} else if(n.equals("CATEGORIAL")) {
			m_concept_type=CATEGORIAL;
		} else if(n.equals("NUMERIC")) {
			m_concept_type=NUMERIC;
		} else if(n.equals("ORDINAL")) {
			m_concept_type=ORDINAL;
		} else if(n.equals("SCALAR")) {
			m_concept_type=SCALAR;
		} else if(n.equals("TIME")) {
			m_concept_type=TIME;
		} else if(n.equals("BINARY")) {
			m_concept_type=BINARY;
		} else {
			throw new Exception(n+" is an unknown conceptual datatype");
		} 
	}
	
	final public Vector getValues() {
		return m_values;
	}
	
	final public void addValue(String s) {
		m_values.add(s);
	}
	
	final public int getValueIndex(Object o) {
		int i;
		for(i=0; i<m_values.size(); ++i) {
			if(m_values.elementAt(i).equals(o)) {
				return i;
			}
		}
		m_values.add(o);
		return m_values.size()-1;
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: ColumnInfo.java,v $
 * Revision 1.4  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:14  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:33  hakenjos
 * Initial version!
 *
 */
