/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.C45;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;

import edu.udo.cs.miningmart.operator.ExecutableOperator;

import edu.udo.cs.miningmart.m4.Step;

/**
 * @author Alessandro Serra
 * @version $Id: TreeWrapper.java,v 1.4 2006/04/11 14:10:09 euler Exp $
 */
public class TreeWrapper extends C45Wrapper {
	protected Tree m_tree;
	protected double m_pruning_confidence;
	protected int m_min_obj;


	public TreeWrapper(Step step, ExecutableOperator exOp) throws Exception {
		super(step, exOp);
		m_pruning_confidence=0.25;
		m_min_obj=2;
	}
	public void setPruningConfidence(double v) {
		m_pruning_confidence=v;
	}
	public void setMinObj(int v) {
		m_min_obj=v;
	}
	protected void callTool() throws Exception {
		callScript("c4.5 -c "+m_pruning_confidence
				+" -m "+m_min_obj
				+" -f "+ m_file_name);
		callScript("tree2dlf -f "+ m_file_name);
	}
	protected void importResult() throws Exception {
		Reader r = new BufferedReader(
			new FileReader(m_file_name+"_tree.dlf"));
		TreeParser tp=new TreeParser(r);
		m_tree=tp.parse();
	}
	protected void saveResult() throws Exception {
		Tree2PLSql t2sql=new Tree2PLSql();
		t2sql.setMetaData(m_md);
		t2sql.setResultName(m_result_name);
		t2sql.setConnection(this.getM4Db());
		t2sql.convert(m_tree);
	}	
};
/*
 * Historie
 * --------
 * 
 * $Log: TreeWrapper.java,v $
 * Revision 1.4  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:11  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:02  hakenjos
 * Initial version!
 *
 */
