/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.C45;


import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import edu.udo.cs.miningmart.compiler.wrapper.dista.DLFTokenizer;
import edu.udo.cs.miningmart.compiler.wrapper.dista.DMException;

/**
 * 
 * @author Alessandro Serra, Timm Euler
 * @version $Id: TreeParser.java,v 1.4 2006/04/11 14:10:09 euler Exp $
 */
public class TreeParser {
   	DLFTokenizer m_st;
	Schema l_schema;

	public TreeParser(Reader r) {
   		m_st = new DLFTokenizer(r);
	}

	protected Attribute parseAttr() throws Exception {
		Attribute attr=null;
		String ty=m_st.getWord();
		if(ty.equals("nom")) {
			m_st.checkBeginRecord();
			attr=new NominalAttribute();
			attr.setName(m_st.getString());
			m_st.checkEndRecord();
		} else if(ty.equals("num")) {
			m_st.checkBeginRecord();
			attr=new NumericAttribute();
			attr.setName(m_st.getString());
			m_st.checkEndRecord();
		} else {
			throw new DMException(
				m_st.errorMsg("expected nom/num words"));
		}
		return attr;
	}
	protected Node parseNominalNode() throws Exception {
		NominalNode n=new NominalNode();
	
		m_st.checkBeginRecord();
		n.setAttr(l_schema.findAttr(m_st.getString()));
		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			m_st.checkBeginRecord();
			n.addValueName(m_st.getString());
			Node child=parseNode();
			n.addChild(child);
			m_st.checkEndRecord();
		}
		m_st.checkEndRecord();
		return n;
	}
	protected Node parseNumericNode() throws Exception {
		NumericNode n=new NumericNode();
		
		m_st.checkBeginRecord();
		if(!m_st.getWord().equals("le")) {
			throw new DMException
				(m_st.errorMsg("expected le word"));
		}
		n.setAttr(l_schema.findAttr(m_st.getString()));
		n.setValue(m_st.getNumber());
		n.addChild(parseNode());
		n.addChild(parseNode());
		m_st.checkEndRecord();

		return n;
	}
	protected Node parseReturnNode() throws Exception {
		ReturnNode n=new ReturnNode();
		m_st.checkBeginRecord();
		n.setValueName(m_st.getString());
		m_st.checkEndRecord();
		return n;
	}
	protected Node parseNode() throws Exception {
		Node n=null;
		String ty=m_st.getWord();
		if(ty.equals("nom")) {
			n=parseNominalNode();
		} else if(ty.equals("num")) {
			n=parseNumericNode();
		} else if(ty.equals("return")) {
			n=parseReturnNode();
		} else {
			throw new DMException(m_st.errorMsg
				("expected nom/num/return words"));
		}
		return n;
	}

	public Tree parse() throws Exception {
		Tree tree=new Tree();
		l_schema=new Schema();
		tree.setSchema(l_schema);
	
		m_st.nextToken();
		if(!m_st.getWord().equals("tree")) {
			throw new DMException(
				m_st.errorMsg("expected tree word"));
		};
		m_st.checkBeginRecord();

		m_st.checkBeginList();
		while(!m_st.isEndList()) {
			l_schema.addAttr(parseAttr());
		}
		
		tree.setRoot(parseNode());
		m_st.checkEndRecord();

		l_schema=null;
		m_st.checkEOF();
		return tree;
	}


	public static void main(String args[]) {
		Tree tree;
		try {
			Reader r = new BufferedReader(new FileReader(args[0]));
			TreeParser tp=new TreeParser(r);
			
			tree=tp.parse();
			
			Writer w= new BufferedWriter(new FileWriter(args[1]));
			PrintWriter pw=new PrintWriter(w);
			
			tree.dumpOn(pw);
			pw.close();
			w.close();	
			
		} catch(Exception e) {
			System.out.print("Error= "+e);
		}
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: TreeParser.java,v $
 * Revision 1.4  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/03/30 16:07:12  scholz
 * fixed author tags for release
 *
 * Revision 1.1  2006/01/03 09:54:02  hakenjos
 * Initial version!
 *
 */
