/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.C45;

import java.io.PrintWriter;

import edu.udo.cs.miningmart.compiler.wrapper.dista.ColumnInfo;
import edu.udo.cs.miningmart.compiler.wrapper.dista.ToPLSql;

/**
 * 
 * @author Alessandro Serra, Timm Euler
 * @version $Id: C452PLSql.java,v 1.5 2006/04/11 14:10:09 euler Exp $
 */
public class C452PLSql extends ToPLSql {
	public C452PLSql() {
		super();
	}
	protected void printValue(PrintWriter w, Object v, ColumnInfo ci) {
		switch(ci.getConceptType()) {
			case ColumnInfo.SCALAR:
			case ColumnInfo.TIME:
			case ColumnInfo.NUMERIC:
				switch(ci.getDataType()) {
					case ColumnInfo.STRING:
						// impossible
						break;
					case ColumnInfo.DATE:
						w.print("m4_timestamp_to_date("+
							v+")");
						break;
					case ColumnInfo.NUMBER:
					    try {
					    	Double d = null;
					    	if (v instanceof String) {
					    		d = Double.valueOf((String) v);
					    	}
					    	else {
					    		d = (Double) v;
					    	}
					  		if (d.doubleValue() < 0) {
					    		w.print("(" + v + ")");
						    }
						    else {
								w.print(v);
						    }
					    }
					    catch (ClassCastException cce) {
					    	System.out.println("C452PLSql.printValue(): Expected Double, could not cast!");
					    }
						break;
				}
				break;
			case ColumnInfo.ORDINAL:
				switch(ci.getDataType()) {
					case ColumnInfo.STRING:
						int i=(new Double(v.toString())).
							intValue();
						w.print("'"+ci.getValues()
							.elementAt(i)+"'");
						break;
					case ColumnInfo.DATE:
						w.print("m4_timestamp_to_date("+
							v+")");
						break;
					case ColumnInfo.NUMBER:
					    try {
					    	Double d = null;
					    	if (v instanceof String) {
					    		d = Double.valueOf((String) v);
					    	}
					    	else {
					    		d = (Double) v;
					    	}
					  		if (d.doubleValue() < 0) {
					    		w.print("(" + v + ")");
						    }
						    else {
								w.print(v);
						    }
					    }
					    catch (ClassCastException cce) {
					    	System.out.println("C452PLSql.printValue(): Expected Double, could not cast!");
					    }
						break;
				}
				break;
			case ColumnInfo.CATEGORIAL:
			case ColumnInfo.BINARY:
			case ColumnInfo.NOMINAL:
				switch(ci.getDataType()) {
					case ColumnInfo.STRING:
						int i=new Integer(v.toString())
							.intValue();
						w.print("'"+ci.getValues()
							.elementAt(i)+"'");
						break;
					case ColumnInfo.DATE:
						w.print("m4_timestamp_to_date("+
							v+")");
						break;
					case ColumnInfo.NUMBER:
					    try {
					    	Double d = null;
					    	if (v instanceof String) {
					    		d = Double.valueOf((String) v);
					    	}
					    	else {
					    		d = (Double) v;
					    	}
					  		if (d.doubleValue() < 0) {
					    		w.print("(" + v + ")");
						    }
						    else {
								w.print(v);
						    }
					    }
					    catch (ClassCastException cce) {
					    	System.out.println("C452PLSql.printValue(): Expected Double, could not cast!");
					    }
						break;
				}
				break;
		}
	}
};
/*
 * Historie
 * --------
 * 
 * $Log: C452PLSql.java,v $
 * Revision 1.5  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.4  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.3  2006/03/30 16:07:11  scholz
 * fixed author tags for release
 *
 * Revision 1.2  2006/01/05 14:10:38  euler
 * Bugfixes
 *
 * Revision 1.1  2006/01/03 09:54:02  hakenjos
 * Initial version!
 *
 */
