/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper;

import java.sql.SQLException;

import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.m4.utils.Print;

import edu.udo.cs.miningmart.exception.M4CompilerError;

/**
 * This class is the wrapper for a classification SVM that runs inside the database.
 * 
 * @author Timm Euler
 * @version $Id: DB_SVM_CL.java,v 1.4 2006/04/11 14:10:17 euler Exp $
 */
public class DB_SVM_CL extends DB_SVM
{
	/**
	 * Use this constructor if no sampling on the input data is needed.
	 * 
     * @param databaseObj the DB object to be used for database connections
     * @param printObj the Print object to be used for log messages
     * @param nameForDatabaseUse Prefix for all functions, view and tables that
     * 	      this wrapper creates in the database
     * @param nameOfDatabaseSchema Name of the database schema that holds the business 
     *        views and tables
     * @param stepId Id of the step
     * @param keyCol name of the column that is a key to the input table
     * @param positiveTargetValue Decides which of the two values of the target 
     *  	  attribute is to be interpreted as the positive label.
     *
     * @throws M4CompilerError A simple exception object with an error message.
	 */
	public DB_SVM_CL( CompilerDatabaseService databaseObj,
					  Print printObj,
					  String nameForDatabaseUse,
					  String nameOfDatabaseSchema,
					  long stepId,
					  String keyCol,
					  String positiveTargetValue)
		throws M4CompilerError
	{
		super(databaseObj, printObj, nameForDatabaseUse, nameOfDatabaseSchema, stepId, keyCol);
        this.forClassification = true;
        this.setPositiveTargetValue(positiveTargetValue);        
	}
	
	/**
	 * Use this constructor if sampling on the input data is needed.
	 * 
     * @param databaseObj the DB object to be used for database connections
     * @param printObj the Print object to be used for log messages
     * @param nameForDatabaseUse Prefix for all functions, view and tables that
     * 	      this wrapper creates in the database
     * @param nameOfDatabaseSchema Name of the database schema that holds the business 
     *        views and tables
     * @param stepId Id of the step
     * @param keyCol name of the column that is a key to the input table
     * @param positiveTargetValue Decides which of the two values of the target 
     *  	  attribute is to be interpreted as the positive label.
     * @param sampleSize maximum number of rows to be used to train the SVM
     *
     * @throws M4CompilerError A simple exception object with an error message.
	 */
	public DB_SVM_CL( CompilerDatabaseService databaseObj,
					  Print printObj,
					  String nameForDatabaseUse,
					  String nameOfDatabaseSchema,
					  long stepId,
					  String keyCol,
					  long sampleSize,
					  String positiveTargetValue)
		throws M4CompilerError
	{
		super(databaseObj, printObj, nameForDatabaseUse, nameOfDatabaseSchema, stepId, keyCol, sampleSize);
        this.forClassification = true;
        this.setPositiveTargetValue(positiveTargetValue);        
	}

    /**
     * @see edu.udo.cs.miningmart.operator.SVM_Wrapper#extractXiAlpha
     */
    protected void extractXiAlpha() throws M4CompilerError
    {
    	try
    	{
    		String query = "SELECT value FROM " + this.getLogTableName() + " WHERE parameter = 'xi_alpha_accuracy'";
    	    String result = this.getDatabaseObj().executeBusinessSingleValueSqlRead(query);
    		if (result != null)
    		{
				this.xiAlphaEstimation = Double.parseDouble(result);
    		}
    		else
    		{  throw new M4CompilerError("DB-SVM wrapper: could not find XiAlpha-Estimation in SVM output!" +
    									 " Tried to read from table: " + this.getLogTableName());  }
    	}
    	catch (SQLException sqle)
    	{  throw new M4CompilerError("DB-SVM wrapper: error trying to read XiAlpha-Estimation: " + sqle.getMessage());  }
    	catch (NumberFormatException nfe)
    	{  throw new M4CompilerError("DB-SVM wrapper: error trying to read XiAlpha-Estimation: " + nfe.getMessage()); }
    }
}
/*
 * Historie
 * --------
 * 
 * $Log: DB_SVM_CL.java,v $
 * Revision 1.4  2006/04/11 14:10:17  euler
 * Updated license text.
 *
 * Revision 1.3  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.2  2006/01/05 10:27:38  hakenjos
 * Removed Javadoc Warnings!
 *
 * Revision 1.1  2006/01/03 09:54:36  hakenjos
 * Initial version!
 *
 */
