/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper;

import java.util.HashMap;
import java.util.Iterator;

import edu.udo.cs.miningmart.m4.Column;

/**
 * This class stores specific information about a database column.
 * It is used by wrappers for the M4 compiler. 
 * 
 * @author Timm Euler
 * @version $Id: ColumnInfo.java,v 1.3 2006/04/11 14:10:18 euler Exp $
 */
class ColumnInfo {
	
	private Column myColumn;                // column to be represented
	private String selectStringForColumn;   // how the column should be accessed
	private String datatype;                // database-specific datatype of the column
	private HashMap valuesToStrings = null; // used to convert nominal values to numbers
	private boolean hasMissingValues;       // TRUE if NULLs occur in this column
	

	/**
	 * Constructor. At least the column is needed.
	 */
	public ColumnInfo(Column theColumn, boolean hasMissingValues) {
		this.myColumn = theColumn;
		this.hasMissingValues = hasMissingValues;
	}
	
	Column getColumn() {
		return this.myColumn;
	}
	
	boolean mappingIsUsed() {
		return (this.valuesToStrings != null);
	}	
	
	boolean hasMissingValues() {
		return this.hasMissingValues;
	}
	
	int getNumberOfValues() {
		return this.valuesToStrings.size();
	}
	
	void setValueMapping(String value, String mappedValue) {
		if (this.valuesToStrings == null) {
			this.valuesToStrings = new HashMap();
		}
		this.valuesToStrings.put(value, mappedValue);
	}
	
	Iterator getValuesIterator() {
		return this.valuesToStrings.keySet().iterator();
	}
	
	String getMappedValue(String value) {
		if (this.valuesToStrings == null) {
			return null;
		}
		else return (String) this.valuesToStrings.get(value);
	}
	
	/**
	 * Returns how the column should be accessed in the database
	 * (eg including conversion functions).
	 * 
	 * @return Returns the selectStringForColumn.
	 */
	String getSelectString() {
		return selectStringForColumn;
	}	
	
	/**
	 * Set how the column should be accessed in the database.
	 * 
	 * @param selectStringForColumn The selectStringForColumn to set.
	 */
	void setSelectString(String selectStringForColumn) {
		this.selectStringForColumn = selectStringForColumn;
	}
	
	/**
	 * @return Returns the columnName.
	 */
	String getColumnName() {
		return this.myColumn.getName();
	}
	
	/**
	 * @return Returns the datatype.
	 */
	public String getDatatype() {
		return datatype;
	}
	
	/**
	 * @param datatype The datatype to set.
	 */
	public void setDatatype(String datatype) {
		this.datatype = datatype;
	}
}
/*
 * Historie
 * --------
 * 
 * $Log: ColumnInfo.java,v $
 * Revision 1.3  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:37  hakenjos
 * Initial version!
 *
 */
