/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.utils;

import edu.udo.cs.miningmart.exception.M4Exception;

/**
 * @author Martin Scholz
 * @version $Id: Binarify.java,v 1.3 2006/04/11 14:10:18 euler Exp $
 */
public class Binarify extends AttributeCreationTool {

	private final int USER_DEF_GROUPING_OP_ID = 104;
	
	/**
	 * Private constructor.
	 * @param dbConfig the path to the <code>dbConfig</code> file.
	 * @param conceptId the ID of the input concept to the new step
	 * @param baId the ID of the target base attribute 
	 * @param chainId the ID of the chain the new step should belong to
	 */
	public Binarify( edu.udo.cs.miningmart.m4.Concept concept, 
			         edu.udo.cs.miningmart.m4.BaseAttribute ba, 
			         edu.udo.cs.miningmart.m4.Chain chain)	throws M4Exception {
		super(concept, ba, chain);
	}

	/**
	 * @see miningmart.compiler.utils.AttributeCreationTool#insertSpecificParameters(int, int, String)
	 */
	protected void insertSpecificParameters(int loopNr, int parNr, String targetValS) throws M4Exception {
		
		// ***** Create looped parameters *****
		int numericConDT = 7; // conceptual datatype 'numeric'
		int stringConDT =  1; // conceptual datatype 'nominal'

		// Interval starts and ends with the target value
		this.createInputValueParameter("TheGroupings", loopNr, targetValS, stringConDT,  parNr++);
		this.createInputValueParameter("Labels",       loopNr, "1",        numericConDT, parNr++);

		// All the other values are mapped to 0:
		this.createInputValueParameter("Default",  loopNr, "0", numericConDT, parNr++);		
	}

	/**
	 * @see miningmart.compiler.utils.AttributeCreationTool#getIdOfOperator()
	 */
	protected int getIdOfOperator() {
		return USER_DEF_GROUPING_OP_ID;
	}
	
	/**
	 * @see miningmart.compiler.utils.AttributeCreationTool#getNameOfOperator()
	 */
	protected String getNameOfOperator() {
		return "UserDefinedGroupingWithDefaultValue";
	}

	/**
	 * @see miningmart.compiler.utils.AttributeCreationTool#getNameOfNewStep()
	 */
	protected String getNameOfNewStep() {
		return "Binarify Attribute";
	}

	/**
	 * @see miningmart.compiler.utils.AttributeCreationTool#getConceptualDatatypeNameOfNewAttributes()
	 */	 
	protected String getConceptualDatatypeNameOfNewAttributes() throws M4Exception {
		return "BINARY";
	}
}
/*
 * Historie
 * --------
 *
 * $Log: Binarify.java,v $
 * Revision 1.3  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:18  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:35  hakenjos
 * Initial version!
 *
 */
