/*
 * MiningMart Version 1.0
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler;
/**
 * @author Martin Scholz
 * @version $Id: SystemPropertyInterface.java,v 1.3 2006/04/11 14:10:09 euler Exp $
 */
public class SystemPropertyInterface {

	/** The global MiningMart system directory */
	public static final String NAME_MM_GLOBAL_HOME = "MM_HOME";

	/** The user's local directory with write access */
	public static final String NAME_MM_LOCAL_HOME  = "MM_LOCAL";

	/** The user's temporary directory */
	public static final String NAME_MM_TEMP        = "TEMP_DIR";

	/** Directory plus file name prefix for compiler log-files. */
	public static final String NAME_MM_LOG         = "LOG_FILES";

	/** The print verbosity of the M4 interface */	
	public static final String NAME_M4I_PRINT_VERB = "PRINT_VERBOSITY";

	/** The path to the database configuration file */
	public static final String NAME_DB_CONFIG      = "DB_CONFIG_PATH";

	/** Old reference alias still used by the HCI */
	public static final String NAME_SPIN_HOME      = "spin.home";

	/** Compiler directory containing operator binaries etc. in sub-directories */
	public static final String NAME_COMPILER_HOME  = "ML_HOME";


	/**
	 * Service method to get a system property. Does allow for calculating
	 * properties not explicitly set by the user.
	 * 
	 * @param name the name of the system property
	 */
	public static String getProperty(String name) {
		return System.getProperty(name);	
	}
}
/*
 * Historie
 * --------
 *
 * $Log: SystemPropertyInterface.java,v $
 * Revision 1.3  2006/04/11 14:10:09  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:09  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:31  hakenjos
 * Initial version!
 *
 */
