#!/bin/sh

##############################################################
#                                                            #
#    This is the M4 installation script for a PostgreSQL     #
#    database.                                               #
#    Version: 0.1                                            #
#    Author: Timm Euler                                      #
#    Date: Januray 2006                                      #
#                                                            #
############################################################## 
#                                                            #
#                       ATTENTION !!!                        # 
#                                                            #
# Do not run this script if you have valuable data in        #
# your M4 schema. The script deletes all M4 tables !!        # 
#                                                            #
############################################################## 
#                                                            #
# Please note that PostgreSQL 7.2.3 does not support         #
# password authentification via scripts such as this one.    #
# Therefore, your database server must be configured such    #
# as to accept all database connection requests from the     #
# client you are using.                                      #
#                                                            #
# Also note that for MiningMart, each user must have a       #
# schema whose name is the same as the username. This schema #
# is not created by this script but is expected to exist.    #
#                                                            #
##############################################################
#                                                            #
# Before running the script, please edit the following       #
# variables.                                                 #
#                                                            #
##############################################################
#
# Please set the host, port, and database name:
HOST=""
PORT=""
DBNAME=""

# Please set username (which is the same as the schemaname) -
# - for the M4 schema:
M4USER=""

# - for the business data schema:
BDUSER=""

# Please set the following variable to a filename which can  
# be used for a log file:                        
LOG_FILENAME=""

# Please set the following variable to your own PostgreSQL   
# binaries directory:
PATH="${PATH}"
export PATH

##############################################################
#                                                            #
# Do not edit anything below this line.                      #
#                                                            #
##############################################################

echo M4 schema: Installing M4 tables! | tee ${LOG_FILENAME}
psql -h ${HOST} -p ${PORT} -U ${M4USER} ${DBNAME} < CreateM4Tables.sql > ${LOG_FILENAME} 2>&1

echo M4 schema: Installing M4 operator information! | tee -a ${LOG_FILENAME}
psql -h ${HOST} -p ${PORT} -U ${M4USER} ${DBNAME} < Operators.sql >> ${LOG_FILENAME} 2>&1

echo M4 schema: Installing a sequence! | tee -a ${LOG_FILENAME}
psql -h ${HOST} -p ${PORT} -U ${M4USER} ${DBNAME} < MM_Sequence.sql >> ${LOG_FILENAME} 2>&1
