@echo off

rem # Do not edit the first line of this file above unless you know what it means.
rem #
rem # Please enter below the path to your MiningMart installation (or set it in
rem # an environment variable if you know how to do that). It should be the
rem # same value as given for MM_HOME in the file 
rem # MM_HOME/config/MiningMartHome.properties.

set MMART_HOME=.\..

rem # You may have to edit one of the following lines if the file name 
rem # is not correct.

set ORA=%MMART_HOME%\lib\classes12.zip
set POSTGR=%MMART_HOME%\lib\postgresql.jar

rem # Probably you do not need to edit anything below this line.

set JAVA=%JAVA_HOME%\bin\java
if "%JAVA_HOME%"=="" goto error2

if "%MAX_JAVA_MEMORY%"=="" set MAX_JAVA_MEMORY=128

set MMART_JAR=%MMART_HOME%\lib\mmart.jar
set BUILD=%MMART_HOME%\build
set MMART_CLASSPATH=

if exist %MMART_JAR% set MMART_CLASSPATH=%MMART_JAR%
if exist %BUILD%/nul set MMART_CLASSPATH=%BUILD%
if "%MMART_CLASSPATH%"=="" goto error1

set CONFIG=%MMART_HOME%\build

set LIBS=%MMART_HOME%\lib\commons-codec.jar;%MMART_HOME%\lib\jhotdraw-6.0b1.jar;%MMART_HOME%\lib\kxml.jar;%MMART_HOME%\lib\LiMo.jar;%MMART_HOME%\lib\MmSm-LIB.jar;%MMART_HOME%\lib\MmSmMetadata-LIB.zip;%MMART_HOME%\lib\yale.jar;%MMART_HOME%\lib\epsgraphics.jar
set CLASSPATH=%MMART_CLASSPATH%;%CONFIG%;%LIBS%;%CLASSPATH%
if exist %ORA% set CLASSPATH=%CLASSPATH%;%ORA%
if exist %POSTGR% set CLASSPATH=%CLASSPATH%;%POSTGR%

echo Starting MiningMart from %MMART_HOME% using classes from %MMART_CLASSPATH%...
%JAVA% -Xmx%MAX_JAVA_MEMORY%m -classpath %CLASSPATH% edu.udo.cs.miningmart.gui.application.MiningMartApplication
goto end

:error1
echo Neither %MMART_JAR% nor %BUILD% was found.
echo Try 'ant build' or 'ant jar' first.
pause
goto end

:error2
echo JAVA_HOME not set. Please install Java properly or check if JAVA_HOME is correctly set.
goto end

:end


