/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.PGConnection;
import org.postgresql.jdbc2.AbstractJdbc2Connection;
import org.postgresql.jdbc2.AbstractJdbc2ResultSet;
import org.postgresql.util.PSQLException;

public class Array
implements java.sql.Array {
    private PGConnection conn = null;
    private Field field = null;
    private ResultSet rs;
    private int idx = 0;
    private String rawString = null;

    public Array(PGConnection conn, int idx, Field field, ResultSet rs) throws SQLException {
        this.conn = conn;
        this.field = field;
        this.rs = rs;
        this.idx = idx;
        this.rawString = ((AbstractJdbc2ResultSet)((Object)rs)).getFixedString(idx);
    }

    public Object getArray() throws SQLException {
        return this.getArray(1L, 0, (Map)null);
    }

    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(index, count, (Map)null);
    }

    public Object getArray(Map map) throws SQLException {
        return this.getArray(1L, 0, map);
    }

    public Object getArray(long index, int count, Map map) throws SQLException {
        if (map != null) {
            throw Driver.notImplemented();
        }
        if (index < 1L) {
            throw new PSQLException("postgresql.arr.range");
        }
        Object[] retVal = null;
        ArrayList<String> array = new ArrayList<String>();
        if (this.rawString != null && !this.rawString.equals("{}")) {
            char[] chars = this.rawString.toCharArray();
            StringBuffer sbuf = new StringBuffer();
            boolean foundOpen = false;
            boolean insideString = false;
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == '\\') {
                    ++i;
                }
                if (chars[i] == '{') {
                    if (foundOpen) {
                        throw Driver.notImplemented();
                    }
                    foundOpen = true;
                } else if (chars[i] == '\"') {
                    insideString = !insideString;
                } else if (!insideString && chars[i] == ',' || chars[i] == '}' || i == chars.length - 1) {
                    if (chars[i] != '\"' && chars[i] != '}' && chars[i] != ',') {
                        sbuf.append(chars[i]);
                    }
                    array.add(sbuf.toString());
                    sbuf = new StringBuffer();
                } else {
                    sbuf.append(chars[i]);
                }
                ++i;
            }
        }
        String[] arrayContents = array.toArray(new String[array.size()]);
        if (count == 0) {
            count = arrayContents.length;
        }
        if (--index + (long)count > (long)arrayContents.length) {
            throw new PSQLException("postgresql.arr.range");
        }
        int i = 0;
        switch (this.getBaseType()) {
            case -7: {
                retVal = new boolean[count];
                while (count > 0) {
                    retVal[i++] = AbstractJdbc2ResultSet.toBoolean(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 4: 
            case 5: {
                retVal = new int[count];
                while (count > 0) {
                    ((int[])retVal)[i++] = AbstractJdbc2ResultSet.toInt(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case -5: {
                retVal = new long[count];
                while (count > 0) {
                    ((long[])retVal)[i++] = AbstractJdbc2ResultSet.toLong(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 2: {
                retVal = new BigDecimal[count];
                while (count > 0) {
                    ((BigDecimal[])retVal)[i++] = AbstractJdbc2ResultSet.toBigDecimal(arrayContents[(int)index++], 0);
                    --count;
                }
                break;
            }
            case 7: {
                retVal = new float[count];
                while (count > 0) {
                    ((float[])retVal)[i++] = AbstractJdbc2ResultSet.toFloat(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 8: {
                retVal = new double[count];
                while (count > 0) {
                    ((double[])retVal)[i++] = AbstractJdbc2ResultSet.toDouble(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 1: 
            case 12: {
                retVal = new String[count];
                while (count > 0) {
                    ((String[])retVal)[i++] = arrayContents[(int)index++];
                    --count;
                }
                break;
            }
            case 91: {
                retVal = new Date[count];
                while (count > 0) {
                    ((Date[])retVal)[i++] = AbstractJdbc2ResultSet.toDate(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 92: {
                retVal = new Time[count];
                while (count > 0) {
                    ((Time[])retVal)[i++] = AbstractJdbc2ResultSet.toTime(arrayContents[(int)index++], this.rs, this.getBaseTypeName());
                    --count;
                }
                break;
            }
            case 93: {
                retVal = new Timestamp[count];
                Object sbuf = null;
                while (count > 0) {
                    ((Timestamp[])retVal)[i++] = AbstractJdbc2ResultSet.toTimestamp(arrayContents[(int)index++], this.rs, this.getBaseTypeName());
                    --count;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return retVal;
    }

    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        String fType = this.field.getPGType();
        if (fType.charAt(0) == '_') {
            fType = fType.substring(1);
        }
        return fType;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, 0, (Map)null);
    }

    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSet(index, count, (Map)null);
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return this.getResultSet(1L, 0, map);
    }

    public ResultSet getResultSet(long index, int count, Map map) throws SQLException {
        Object array = this.getArray(index, count, map);
        Vector<byte[][]> rows = new Vector<byte[][]>();
        Field[] fields = new Field[2];
        fields[0] = new Field(this.conn, "INDEX", this.conn.getPGType("int2"), 2);
        switch (this.getBaseType()) {
            case -7: {
                boolean[] booleanArray = (boolean[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("bool"), 1);
                int i = 0;
                while (i < booleanArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(booleanArray[i] ? "YES" : "NO");
                    rows.addElement(tuple);
                    ++i;
                }
            }
            case 5: {
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("int2"), 2);
            }
            case 4: {
                int[] intArray = (int[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("int4"), 4);
                }
                int i = 0;
                while (i < intArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(Integer.toString(intArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case -5: {
                long[] longArray = (long[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("int8"), 8);
                int i = 0;
                while (i < longArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(Long.toString(longArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 2: {
                BigDecimal[] bdArray = (BigDecimal[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("numeric"), -1);
                int i = 0;
                while (i < bdArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(bdArray[i].toString());
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 7: {
                float[] floatArray = (float[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("float4"), 4);
                int i = 0;
                while (i < floatArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(Float.toString(floatArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 8: {
                double[] doubleArray = (double[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("float8"), 8);
                int i = 0;
                while (i < doubleArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(Double.toString(doubleArray[i]));
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 1: {
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("char"), 1);
            }
            case 12: {
                String[] strArray = (String[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("varchar"), -1);
                }
                int i = 0;
                while (i < strArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(strArray[i]);
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("date"), 4);
                int i = 0;
                while (i < dateArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(dateArray[i].toString());
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("time"), 8);
                int i = 0;
                while (i < timeArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(timeArray[i].toString());
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("timestamp"), 8);
                int i = 0;
                while (i < timestampArray.length) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i));
                    tuple[1] = this.conn.getEncoding().encode(timestampArray[i].toString());
                    rows.addElement(tuple);
                    ++i;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return ((AbstractJdbc2Connection)this.conn).getResultSet(null, fields, rows, "OK", 1);
    }

    public String toString() {
        return this.rawString;
    }
}

