/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.plugin;

import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.AboutBox;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.plugin.Dependency;
import edu.udo.cs.yale.tools.plugin.PluginClassLoader;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class Plugin {
    private JarFile archive;
    private PluginClassLoader classLoader;
    private String name;
    private String version;
    private String vendor;
    private String url;
    private String neededYaleVersion = "0";
    private List pluginDependencies = new LinkedList();
    private static List allPlugins = new LinkedList();

    public Plugin(File file) throws IOException {
        this.archive = new JarFile(file);
        URL url = new URL("file", null, file.getAbsolutePath());
        this.classLoader = new PluginClassLoader(new URL[]{url});
        this.getMetaData();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getNeededYaleVersion() {
        return this.neededYaleVersion;
    }

    public List getPluginDependencies() {
        return this.pluginDependencies;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private boolean checkDependencies(List plugins) {
        if (Yale.getVersion().compareTo(this.neededYaleVersion) < 0) {
            return false;
        }
        Iterator i = this.pluginDependencies.iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            if (dependency.isFulfilled(plugins)) continue;
            return false;
        }
        return true;
    }

    private void getMetaData() {
        try {
            String dependencies;
            Attributes atts = this.archive.getManifest().getMainAttributes();
            this.name = atts.getValue("Implementation-Title");
            if (this.name == null) {
                this.name = this.archive.getName();
            }
            this.version = atts.getValue("Implementation-Version");
            if (this.version == null) {
                this.version = "";
            }
            this.url = atts.getValue("Implementation-URL");
            this.vendor = atts.getValue("Implementation-Vendor");
            this.neededYaleVersion = atts.getValue("Yale-Version");
            if (this.neededYaleVersion == null) {
                this.neededYaleVersion = "0";
            }
            if ((dependencies = atts.getValue("Plugin-Dependencies")) == null) {
                dependencies = "";
            }
            this.addDependencies(dependencies);
            Yale.splashMessage("Loading " + this.name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDependencies(String dependencies) {
        String[] singleDependencies = dependencies.trim().split("#");
        for (int i = 0; i < singleDependencies.length; ++i) {
            if (singleDependencies[i].trim().length() <= 0) continue;
            String dependencyName = singleDependencies[i].trim();
            String dependencyVersion = "0";
            if (singleDependencies[i].trim().indexOf("[") > 0) {
                dependencyName = singleDependencies[i].trim().substring(0, singleDependencies[i].trim().indexOf("[")).trim();
                dependencyVersion = singleDependencies[i].trim().substring(singleDependencies[i].trim().indexOf("[") + 1, singleDependencies[i].trim().indexOf("]")).trim();
            }
            this.pluginDependencies.add(new Dependency(dependencyName, dependencyVersion));
        }
    }

    public void register() {
        URL[] urls = this.classLoader.getURLs();
        URL operatorsURL = this.classLoader.getResource("META-INF/operators.xml");
        if (operatorsURL == null && (operatorsURL = this.classLoader.getResource("operators.xml")) != null) {
            LogService.logMessage(this.name + ": putting operators.xml in root directory of jar is deprecated. Use META-INF directory instead!", 4);
        }
        if (operatorsURL == null) {
            LogService.logMessage("Plugin '" + this.archive.getName() + "' does not contain operators.xml!", 6);
        } else {
            Iterator i = this.pluginDependencies.iterator();
            while (i.hasNext()) {
                String pluginName = ((Dependency)i.next()).getPluginName();
                Plugin other = Plugin.getPlugin(pluginName);
                this.mergeClassLoader(other);
            }
            InputStream in = null;
            try {
                in = operatorsURL.openStream();
            }
            catch (IOException e) {
                LogService.logMessage("Cannot read operators.xml from '" + this.archive.getName() + "'!", 6);
            }
            LogService.logMessage("Loading " + this.name, 3);
            OperatorService.registerOperators(this.archive.getName(), in, this.classLoader);
        }
    }

    public AboutBox createAboutBox(Frame owner) {
        String about = "";
        try {
            URL url = this.classLoader.getResource("META-INF/ABOUT.NFO");
            if (url != null) {
                about = Tools.readTextFile(new InputStreamReader(url.openStream()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new AboutBox(owner, this.name, this.version, "Vendor: " + (this.vendor != null ? this.vendor : "unknown") + "\n" + "URL: " + (this.url != null ? this.url : "unknown") + "\n\n" + about, new Image[0]);
    }

    public static void findPlugins() {
        File pluginDir = ParameterService.getPluginDir();
        if (!pluginDir.exists() || !pluginDir.isDirectory()) {
            return;
        }
        File[] files = pluginDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        allPlugins = new LinkedList();
        for (int i = 0; i < files.length; ++i) {
            try {
                allPlugins.add(new Plugin(files[i]));
                continue;
            }
            catch (Throwable e) {
                LogService.logException("Cannot load plugin '" + files[i] + "'", e);
            }
        }
    }

    protected void mergeClassLoader(Plugin other) {
        URL[] otherURLs = other.classLoader.getURLs();
        for (int i = 0; i < otherURLs.length; ++i) {
            this.classLoader.addDependingURL(otherURLs[i]);
        }
    }

    public String toString() {
        return this.name + " " + this.version + " (" + this.archive.getName() + ") depending on " + this.pluginDependencies;
    }

    public static void registerAllPlugins() {
        Plugin.findPlugins();
        Iterator i = allPlugins.iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            if (plugin.checkDependencies(allPlugins)) continue;
            LogService.logMessage("Cannot register operators from '" + plugin.getName() + "': Dependencies not fulfilled! This plugin need Yale version " + plugin.getNeededYaleVersion() + " and the following plugins:\n" + plugin.getPluginDependencies(), 6);
            i.remove();
        }
        if (allPlugins.size() > 0) {
            LogService.logMessage("Found " + allPlugins.size() + " plugins in " + ParameterService.getPluginDir(), 3);
            i = allPlugins.iterator();
            while (i.hasNext()) {
                ((Plugin)i.next()).register();
            }
        }
    }

    public static List getAllPlugins() {
        return allPlugins;
    }

    public static Plugin getPlugin(String name) {
        Iterator i = allPlugins.iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            if (!plugin.getName().equals(name)) continue;
            return plugin;
        }
        return null;
    }
}

