/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math.optimization.ec.pso;

import edu.udo.cs.yale.operator.performance.PerformanceVector;

public class Population {
    private static final int CURRENT = 0;
    private static final int BEST = 1;
    private double[][][] values;
    private double[][] individualFitness;
    private double[] bestValuesEver;
    private PerformanceVector bestPerformanceEver;
    private double generationsBest = Double.NaN;
    private int generation = 0;
    private int lastImprovement = 0;

    public Population(int popSize, int individualSize) {
        this.values = new double[2][popSize][individualSize];
        this.individualFitness = new double[2][popSize];
    }

    public int getNumberOfIndividuals() {
        return this.values[0].length;
    }

    public int getIndividualSize() {
        return this.values[0][0].length;
    }

    public double[] getValues(int index) {
        return this.values[0][index];
    }

    public double[] getLocalBestValues(int index) {
        return this.values[1][index];
    }

    public double[] getGlobalBestValues() {
        return this.bestValuesEver;
    }

    public double getBestFitnessEver() {
        if (this.bestPerformanceEver == null) {
            return Double.NaN;
        }
        return this.bestPerformanceEver.getMainCriterion().getFitness();
    }

    public PerformanceVector getBestPerformanceEver() {
        return this.bestPerformanceEver;
    }

    public double getBestFitnessInGeneration() {
        return this.generationsBest;
    }

    public void setValues(int index, double[] values) {
        this.values[0][index] = values;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void nextGeneration() {
        ++this.generation;
    }

    public int getGenerationsWithoutImprovement() {
        return this.generation - this.lastImprovement;
    }

    public void setFitnessVector(PerformanceVector[] performanceVectors) {
        System.out.println("\n### NEW GENERATION ###");
        double[] fitnessValues = new double[performanceVectors.length];
        for (int i = 0; i < fitnessValues.length; ++i) {
            fitnessValues[i] = performanceVectors[i] == null ? Double.NEGATIVE_INFINITY : performanceVectors[i].getMainCriterion().getFitness();
        }
        this.generationsBest = Double.NEGATIVE_INFINITY;
        int generationsBestIndex = -1;
        for (int i = 0; i < fitnessValues.length; ++i) {
            this.individualFitness[0][i] = fitnessValues[i];
            if (fitnessValues[i] > this.individualFitness[1][i]) {
                for (int d = 0; d < this.values[1][i].length; ++d) {
                    this.values[1][i][d] = this.values[0][i][d];
                }
                this.individualFitness[1][i] = fitnessValues[i];
            }
            if (!(fitnessValues[i] > this.generationsBest)) continue;
            this.generationsBest = fitnessValues[i];
            generationsBestIndex = i;
        }
        if (this.bestPerformanceEver == null || this.generationsBest > this.bestPerformanceEver.getMainCriterion().getFitness()) {
            this.bestPerformanceEver = performanceVectors[generationsBestIndex];
            this.bestValuesEver = new double[this.values[0][0].length];
            for (int d = 0; d < this.bestValuesEver.length; ++d) {
                this.bestValuesEver[d] = this.values[1][generationsBestIndex][d];
            }
            this.lastImprovement = this.generation;
        }
        System.out.println("Best in generation " + this.generation + ": " + this.generationsBest);
        System.out.println("Best ever: " + this.bestPerformanceEver.getMainCriterion().getFitness());
    }
}

