/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.Experiment;
import java.util.Random;

public class RandomGenerator
extends Random {
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static RandomGenerator globalRandomGenerator;

    public RandomGenerator() {
    }

    public RandomGenerator(long seed) {
        super(seed);
    }

    public static RandomGenerator getGlobalRandomGenerator() {
        return globalRandomGenerator;
    }

    public static void init(Experiment experiment) {
        long seed = experiment.getRootOperator().getParameterAsInt("random_seed");
        globalRandomGenerator = seed == -1L ? new RandomGenerator() : new RandomGenerator(seed);
    }

    public double nextDoubleInRange(double lowerBound, double upperBound) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextDoubleInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        return this.nextDouble() * (upperBound - lowerBound) + lowerBound;
    }

    public long nextLongInRange(long lowerBound, long upperBound) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextLongInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        return (long)(this.nextDouble() * (double)(upperBound - lowerBound + 1L)) + lowerBound;
    }

    public int nextIntInRange(int lowerBound, int upperBound) {
        if (upperBound <= lowerBound) {
            throw new IllegalArgumentException("RandomGenerator.nextIntInRange : the upper bound of the random number range should be greater than the lower bound.");
        }
        return (int)(this.nextDouble() * (double)(upperBound - lowerBound + 1)) + lowerBound;
    }

    public String nextString(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = ALPHABET.charAt(this.nextInt(ALPHABET.length()));
        }
        return new String(chars);
    }

    public static int randomIndex(double[] probs) {
        double r = globalRandomGenerator.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            if (!(r < (sum += probs[i]))) continue;
            return i;
        }
        return probs.length - 1;
    }
}

