/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;

public class DatabaseHandler {
    private String databaseName;
    private String databaseURL;
    private String driver;
    private Connection myCon;

    public DatabaseHandler(String dbname, String urlPrefix, String driverClass) {
        this.databaseName = dbname;
        this.databaseURL = urlPrefix + this.databaseName;
        this.driver = driverClass;
        this.myCon = null;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void connect(String username, String passwd, boolean autoCommit) throws SQLException {
        if (this.myCon != null) {
            throw new SQLException("connect: Connection to database '" + this.databaseName + "' already exists!");
        }
        try {
            Tools.classForName(this.driver);
        }
        catch (ClassNotFoundException cnfe) {
            throw new SQLException("connect: Could not find Oracle Driver Class '" + this.driver + "'!");
        }
        this.myCon = DriverManager.getConnection(this.databaseURL, username, passwd);
        this.myCon.setAutoCommit(autoCommit);
    }

    public void disconnect() throws SQLException {
        if (this.myCon == null) {
            throw new SQLException("Disconnect: was not connected.");
        }
        this.myCon.close();
        this.myCon = null;
    }

    public ResultSet query(String sqlQuery) throws SQLException {
        if (this.myCon == null) {
            throw new SQLException("Could not query database '" + this.databaseName + "': not connected.");
        }
        if (!sqlQuery.toLowerCase().startsWith("select")) {
            throw new SQLException("Query: Only SQL-Statements starting with SELECT are allowed: " + sqlQuery);
        }
        Statement st = this.myCon.createStatement(1003, 1008);
        ResultSet rs = st.executeQuery(sqlQuery);
        return rs;
    }

    public void addColumn(Attribute attribute, String tableName) throws SQLException {
        Statement st = this.myCon.createStatement(1003, 1008);
        String query = "alter table " + tableName + " add \"" + DatabaseHandler.getDatabaseName(attribute) + "\" " + (attribute.isNominal() ? "varchar(256)" : "real");
        st.execute(query);
    }

    public void removeColumn(Attribute attribute, String tableName) throws SQLException {
        Statement st = this.myCon.createStatement();
        String query = "alter table " + tableName + " drop column \"" + DatabaseHandler.getDatabaseName(attribute) + "\"";
        st.execute(query);
    }

    public int countRecords(ResultSet rs) throws SQLException {
        int numberOfRows = 0;
        LogService.logMessage("Counting records...", 0);
        rs.beforeFirst();
        while (rs.next()) {
            ++numberOfRows;
        }
        rs.beforeFirst();
        LogService.logMessage("...counted " + numberOfRows + " records.", 0);
        return numberOfRows;
    }

    public void commit() throws SQLException {
        if (this.myCon == null || this.myCon.isClosed()) {
            throw new SQLException("Could not commit: no open connection to database '" + this.databaseName + "' !");
        }
        this.myCon.commit();
    }

    public static int getYaleTypeIndex(int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return 3;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2000: 
            case 2002: 
            case 2004: 
            case 2005: {
                return 1;
            }
            case 91: 
            case 92: 
            case 93: {
                return 5;
            }
        }
        return 1;
    }

    public static List createAttributes(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata;
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (rs == null) {
            throw new IllegalArgumentException("Cannot create attributes: ResultSet must not be null!");
        }
        try {
            metadata = rs.getMetaData();
        }
        catch (NullPointerException npe) {
            throw new RuntimeException("Could not create attribute list: ResultSet object seems closed.");
        }
        int numberOfColumns = metadata.getColumnCount();
        for (int column = 1; column <= numberOfColumns; ++column) {
            String name = metadata.getColumnName(column);
            Attribute attribute = AttributeFactory.createAttribute(name, DatabaseHandler.getYaleTypeIndex(metadata.getColumnType(column)));
            attributes.add(attribute);
        }
        return attributes;
    }

    public static String getDatabaseName(Attribute attribute) {
        String name = attribute.getName();
        return name;
    }
}

