/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.Tools;
import edu.udo.cs.yale.operator.validation.ValidationChain;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.LinkedList;
import java.util.List;

public class FixedSplitValidationChain
extends ValidationChain {
    public FixedSplitValidationChain(OperatorDescription description) {
        super(description);
    }

    public IOObject[] estimatePerformance(ExampleSet inputSet) throws OperatorException {
        int trainingSetSize = this.getParameterAsInt("training_set_size");
        int testSetSize = this.getParameterAsInt("test_set_size");
        int inputSetSize = inputSet.getSize();
        if (inputSetSize < trainingSetSize + testSetSize) {
            throw new UserError((Operator)this, 110, trainingSetSize + testSetSize + " (" + trainingSetSize + " for training, " + testSetSize + " for testing)");
        }
        int rest = inputSetSize - (trainingSetSize + testSetSize);
        if (trainingSetSize < 1 && testSetSize < 1) {
            throw new UserError((Operator)this, 116, "training_set_size / test_set_size", (Object)"either training_set_size or test_set_size or both must be greater than 1.");
        }
        if (testSetSize < 1) {
            rest = 0;
            testSetSize = inputSetSize - trainingSetSize;
        } else if (trainingSetSize < 1) {
            rest = 0;
            trainingSetSize = inputSetSize - testSetSize;
        }
        LogService.logMessage("Using " + trainingSetSize + " examples for learning and " + testSetSize + " examples for testing. " + rest + " examples are not used.", 2);
        double[] ratios = new double[]{(double)trainingSetSize / (double)inputSetSize, (double)testSetSize / (double)inputSetSize, (double)rest / (double)inputSetSize};
        SplittedExampleSet eSet = new SplittedExampleSet(inputSet, ratios, this.getParameterAsInt("sampling_type"));
        eSet.selectSingleSubset(0);
        this.learn(eSet);
        eSet.selectSingleSubset(1);
        IOContainer evalRes = this.evaluate(eSet);
        LinkedList averageVectors = new LinkedList();
        Tools.handleAverages(evalRes, averageVectors);
        PerformanceVector performanceVector = this.getPerformanceVector(averageVectors);
        if (performanceVector != null) {
            this.setResult(performanceVector.getMainCriterion());
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("training_set_size", "Absolute size required for the training set (-1: use rest for training).", -1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("test_set_size", "Absolute size required for the test set (-1: use rest for testing).", -1, Integer.MAX_VALUE, -1);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("sampling_type", "Defines the sampling type of the cross validation.", SplittedExampleSet.SAMPLING_NAMES, 1));
        return types;
    }

    public int getNumberOfValidationSteps() {
        return 1;
    }
}

