/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Obfuscator
extends Operator {
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public Obfuscator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Obfuscator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        HashMap obfuscatorMap = new HashMap();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            this.obfuscateAttribute(exampleSet.getAttribute(i), obfuscatorMap);
        }
        Iterator i = exampleSet.getSpecialAttributeNames().iterator();
        while (i.hasNext()) {
            this.obfuscateAttribute(exampleSet.getAttribute((String)i.next()), obfuscatorMap);
        }
        String filename = this.getParameterAsString("obfuscation_map_file");
        if (filename != null && filename.trim().length() > 0) {
            File file = this.getExperiment().resolveFileName(filename);
            try {
                this.writeObfuscatorMap(obfuscatorMap, file);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 303, filename, (Object)e.getMessage());
            }
        }
        return new IOObject[]{exampleSet};
    }

    private void obfuscateAttribute(Attribute attribute, Map obfuscatorMap) {
        String oldName = attribute.getName();
        String newName = RandomGenerator.getGlobalRandomGenerator().nextString(8);
        attribute.setName(newName);
        attribute.clearConstructionDescription();
        obfuscatorMap.put(newName, oldName);
        if (attribute.isNominal()) {
            Iterator v = attribute.getValues().iterator();
            while (v.hasNext()) {
                String oldValue = (String)v.next();
                String newValue = RandomGenerator.getGlobalRandomGenerator().nextString(8);
                attribute.replaceValue(oldValue, newValue);
                obfuscatorMap.put(oldName + ":" + newValue, oldValue);
            }
        }
    }

    private void writeObfuscatorMap(Map obfuscatorMap, File file) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        Iterator i = obfuscatorMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)obfuscatorMap.get(key);
            out.println(key + "\t" + value);
        }
        out.close();
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Obfuscator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Obfuscator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile("obfuscation_map_file", "File where the obfuscator map should be written to.", true);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

