/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SparseArrayDataRow;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class NominalToBinary
extends Operator {
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public NominalToBinary(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = NominalToBinary.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        ArrayList<Object> attributes = new ArrayList<Object>();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            Attribute attribute = exampleSet.getAttribute(i);
            if (attribute.isNominal() && attribute.getValues().size() > 2) {
                this.handleNominalAttribute(attribute, attributes);
                continue;
            }
            attributes.add(attribute.clone());
        }
        HashMap<String, Attribute> specialAttributeMap = new HashMap<String, Attribute>();
        Iterator i = exampleSet.getSpecialAttributeNames().iterator();
        while (i.hasNext()) {
            String specialName = (String)i.next();
            Attribute special = exampleSet.getAttribute(specialName);
            Attribute newSpecial = (Attribute)special.clone();
            attributes.add(newSpecial);
            specialAttributeMap.put(specialName, newSpecial);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        ExampleReader reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example example = reader.next();
            int index = 0;
            SparseArrayDataRow dataRow = new SparseArrayDataRow(example.getNumberOfAttributes());
            for (int a = 0; a < example.getNumberOfAttributes(); ++a) {
                Attribute attribute = example.getAttribute(a);
                if (attribute.isNominal() && attribute.getValues().size() > 2) {
                    int trueAttributeIndex = (int)example.getValue(attribute);
                    Attribute currentNewAttribute = (Attribute)attributes.get(index + trueAttributeIndex);
                    dataRow.set(currentNewAttribute, currentNewAttribute.mapString("true"));
                    index += attribute.getValues().size();
                    continue;
                }
                dataRow.set((Attribute)attributes.get(index++), example.getValue(attribute));
            }
            Iterator s = exampleSet.getSpecialAttributeNames().iterator();
            while (s.hasNext()) {
                String specialName = (String)s.next();
                Attribute special = exampleSet.getAttribute(specialName);
                dataRow.set((Attribute)attributes.get(index++), example.getValue(special));
            }
            dataRow.trim();
            table.addDataRow(dataRow);
        }
        ExampleSet resultSet = table.createCompleteExampleSet(specialAttributeMap);
        return new IOObject[]{resultSet};
    }

    public void handleNominalAttribute(Attribute attribute, List attributeList) {
        Collection attributeValues = attribute.getValues();
        Iterator i = attributeValues.iterator();
        while (i.hasNext()) {
            String nominalValue = (String)i.next();
            Attribute newAttribute = AttributeFactory.createAttribute(attribute.getName() + "_" + nominalValue, 8, 3, -1, attribute.unitToString());
            if (newAttribute.mapString("false") != 0) {
                LogService.logMessage("Nominal2Binary filtering: 'false' was not mapped to the first attribute value index!", 4);
            }
            newAttribute.mapString("true");
            attributeList.add(newAttribute);
        }
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = NominalToBinary.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = NominalToBinary.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

