/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.preprocessing.ValueReplenishment;

public class InfiniteValueReplenishment
extends ValueReplenishment {
    private static final int NONE = 0;
    private static final int ZERO = 1;
    private static final int MAX_BYTE = 2;
    private static final int MAX_INT = 3;
    private static final int MAX_DOUBLE = 4;
    private static final int MISSING = 5;
    private static final String[] REP_NAMES = new String[]{"none", "zero", "max_byte", "max_int", "max_double", "missing"};

    public InfiniteValueReplenishment(OperatorDescription description) {
        super(description);
    }

    public boolean replenishValue(double currentValue) {
        return Double.isInfinite(currentValue);
    }

    public String[] getFunctionNames() {
        return REP_NAMES;
    }

    public int getDefaultFunction() {
        return 0;
    }

    public int getDefaultColumnFunction() {
        return 1;
    }

    public double getReplenishmentValue(int functionIndex, Attribute attribute, double currentValue) {
        double sign = currentValue > 0.0 ? 1.0 : -1.0;
        switch (functionIndex) {
            case 0: {
                return currentValue;
            }
            case 1: {
                return 0.0;
            }
            case 2: {
                return currentValue > 0.0 ? 127.0 : -128.0;
            }
            case 3: {
                return currentValue > 0.0 ? 2.147483647E9 : -2.147483648E9;
            }
            case 4: {
                return currentValue > 0.0 ? Double.MAX_VALUE : -1.7976931348623157E308;
            }
            case 5: {
                return Double.NaN;
            }
        }
        throw new RuntimeException("Illegal value functionIndex: " + functionIndex);
    }
}

