/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.preprocessing.FeatureFilter;
import edu.udo.cs.yale.tools.Ontology;
import java.util.List;

public class FeatureBlockTypeFilter
extends FeatureFilter {
    public FeatureBlockTypeFilter(OperatorDescription description) {
        super(description);
    }

    public boolean switchOffFeature(Attribute feature) throws OperatorException {
        int type = this.getParameterAsInt("skip_features_of_type") + 1;
        return Ontology.ATTRIBUTE_BLOCK_TYPE.isA(feature.getBlockType(), type);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        String[] blockTypes = new String[Ontology.BLOCK_TYPE_NAMES.length - 1];
        for (int i = 0; i < blockTypes.length; ++i) {
            blockTypes[i] = Ontology.BLOCK_TYPE_NAMES[i + 1];
        }
        ParameterTypeCategory type = new ParameterTypeCategory("skip_features_of_type", "All features of this type will be deselected off.", blockTypes, 0);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

