/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.parameter;

import edu.udo.cs.yale.operator.parameter.ParameterType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ParameterTypeList
extends ParameterType {
    private List defaultList = new LinkedList();
    private ParameterType valueType;

    public ParameterTypeList(String key, String description, ParameterType valueType) {
        this(key, description, valueType, new LinkedList());
    }

    public ParameterTypeList(String key, String description, ParameterType valueType, List defaultList) {
        super(key, description);
        this.defaultList = defaultList;
        this.valueType = valueType;
        if (valueType.getDescription() == null) {
            valueType.setDescription(description);
        }
    }

    public ParameterType getValueType() {
        return this.valueType;
    }

    public Object checkValue(Object value) {
        Iterator i = ((List)value).iterator();
        LinkedList<Object[]> newList = new LinkedList<Object[]>();
        while (i.hasNext()) {
            Object[] current = (Object[])i.next();
            newList.add(new Object[]{(String)current[0], this.valueType.checkValue(current[1])});
        }
        return newList;
    }

    public Object getDefaultValue() {
        return this.defaultList;
    }

    public String getXML(String indent, String key, Object value) {
        StringBuffer result = new StringBuffer();
        result.append(indent + "<list key=\"" + key + "\">\n");
        Iterator i = ((List)value).iterator();
        while (i.hasNext()) {
            Object[] current = (Object[])i.next();
            result.append(this.valueType.getXML(indent + "  ", (String)current[0], current[1]));
        }
        result.append(indent + "</list>\n");
        return result.toString();
    }

    public String getRange() {
        return "list";
    }
}

