/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.List;

public class ParameterIteration
extends OperatorChain {
    private int numberOfCombinations = 0;
    private PerformanceVector performance;
    private int iteration = 0;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public ParameterIteration(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The last performance."){

            public double getValue() {
                if (ParameterIteration.this.performance != null) {
                    return ParameterIteration.this.performance.getMainCriterion().getValue();
                }
                return Double.NaN;
            }
        });
        this.addValue(new Value("iteration", "The current iteration."){

            public double getValue() {
                return ParameterIteration.this.iteration;
            }
        });
    }

    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        List parameterList = this.getParameterList("parameters");
        Operator[] operators = new Operator[parameterList.size()];
        String[] parameters = new String[parameterList.size()];
        String[][] values = new String[parameterList.size()][];
        int[] currentIndex = new int[parameterList.size()];
        Iterator i = parameterList.iterator();
        int index = 0;
        this.numberOfCombinations = 1;
        while (i.hasNext()) {
            Object[] keyValue = (Object[])i.next();
            String[] parameter = ((String)keyValue[0]).split("\\.");
            if (parameter.length != 2) {
                throw new UserError((Operator)this, 907, keyValue[0]);
            }
            Operator operator = this.getExperiment().getOperator(parameter[0]);
            if (operator == null) {
                throw new UserError((Operator)this, 109, parameter[0]);
            }
            operators[index] = operator;
            parameters[index] = parameter[1];
            ParameterType targetType = operators[index].getParameters().getParameterType(parameters[index]);
            if (targetType == null) {
                throw new UserError((Operator)this, 906, parameter[0] + "." + parameter[1]);
            }
            if (!(targetType instanceof ParameterTypeSingle)) {
                throw new UserError((Operator)this, 908, parameter[0] + "." + parameter[1]);
            }
            values[index] = ((String)keyValue[1]).split(",");
            this.numberOfCombinations *= values[index].length;
            ++index;
        }
        this.iteration = 0;
        while (true) {
            boolean ok;
            block10: {
                LogService.logMessage("Using parameter set", 2);
                for (int j = 0; j < operators.length; ++j) {
                    operators[j].getParameters().setParameter(parameters[j], values[j][currentIndex[j]]);
                    LogService.logMessage(operators[j] + "." + parameters[j] + " = " + values[j][currentIndex[j]], 2);
                }
                this.setInput(input.copy());
                IOObject[] evalout = super.apply();
                IOContainer evalCont = new IOContainer(evalout);
                try {
                    this.performance = (PerformanceVector)evalCont.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? ParameterIteration.class$("edu.udo.cs.yale.operator.performance.PerformanceVector") : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
                }
                catch (MissingIOObjectException e) {
                    LogService.logMessage("Inner operators of ParameterIteration do not provide performance vectors: performance cannot be plotted!", 2);
                }
                ++this.iteration;
                int k = 0;
                ok = true;
                do {
                    int n = k;
                    currentIndex[n] = currentIndex[n] + 1;
                    if (currentIndex[n] < values[k].length) break block10;
                    currentIndex[k] = 0;
                } while (++k < currentIndex.length);
                ok = false;
            }
            if (!ok) break;
            this.inApplyLoop();
        }
        return new IOObject[0];
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[0];
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            input = this.getOperator(i).checkIO(input);
        }
        return this.getDeliveredOutputClasses();
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getNumberOfSteps() {
        return this.numberOfCombinations * (this.getNumberOfChildrensSteps() + 1);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeList type = new ParameterTypeList("parameters", "A list of parameters to optimize", new ParameterTypeString("value", "The values of the parameter (comma-separated"));
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

