/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import Jama.Matrix;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.meta.ParameterOptimizationOperator;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.List;

public abstract class MatrixBasedParameterOptimizationOperator
extends ParameterOptimizationOperator {
    protected Operator[] operatorArray;
    protected String[] parameterNames;
    protected double[] parameterValues;
    protected double[] parameterLogbase;
    protected parameterRange[] parameterRange;
    protected int parameterListSize;
    protected double[] yValues;
    protected Matrix operationMatrix;

    public void getParametersToOptimize() throws OperatorException {
        List parameters = this.getParameterList("parameters");
        boolean scaleOn = this.getParameterAsBoolean("log_scale");
        this.parameterListSize = parameters.size();
        this.operatorArray = new Operator[this.parameterListSize];
        this.parameterNames = new String[this.parameterListSize];
        this.parameterRange = new parameterRange[this.parameterListSize];
        this.parameterValues = new double[this.parameterListSize];
        this.parameterLogbase = new double[this.parameterListSize];
        this.yValues = new double[this.parameterListSize];
        Iterator iter = parameters.iterator();
        int counter = 0;
        while (iter.hasNext()) {
            Object[] listItem = (Object[])iter.next();
            String[] base = ((String)listItem[0]).split("\\.");
            Operator currentParameter = this.getExperiment().getOperator(base[0]);
            if (currentParameter == null) {
                throw new UserError((Operator)this, 907, listItem[0]);
            }
            this.operatorArray[counter] = currentParameter;
            this.parameterNames[counter] = base[1];
            if (base.length < 3) {
                this.parameterLogbase[counter] = 2.0;
            } else {
                try {
                    this.parameterLogbase[counter] = Double.parseDouble(base[2]);
                }
                catch (NumberFormatException e) {
                    throw new UserError((Operator)this, 907, base[0] + "." + base[1]);
                }
            }
            ParameterType targetType = this.operatorArray[counter].getParameters().getParameterType(this.parameterNames[counter]);
            if (targetType == null) {
                throw new UserError((Operator)this, 906, base[0] + "." + base[1]);
            }
            if (!(targetType instanceof ParameterTypeNumber)) {
                throw new UserError((Operator)this, 909, base[0] + "." + base[1]);
            }
            ParameterTypeNumber numberType = (ParameterTypeNumber)targetType;
            double min = numberType.getMinValue();
            double max = numberType.getMaxValue();
            this.parameterRange[counter] = new parameterRange(base[1], min, max);
            this.parameterValues[counter] = this.param2coded((String)listItem[1], this.parameterLogbase[counter]);
            ++counter;
        }
    }

    public MatrixBasedParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    protected void setDataToExperiment(Matrix input, int column) {
        for (int i = 0; i < this.parameterListSize; ++i) {
            this.operatorArray[i].getParameters().setParameter(this.parameterNames[i], this.coded2param(input.get(i, column), this.parameterLogbase[i]));
        }
    }

    protected void insertVector(Matrix vector, int column, double value) {
        this.operationMatrix.setMatrix(0, this.parameterListSize - 1, column, column, vector);
        this.yValues[column] = value;
    }

    protected Matrix getVector(int column) {
        return this.operationMatrix.getMatrix(0, this.parameterListSize - 1, column, column);
    }

    protected int determineHigh(int arraySize) {
        int maxIndex = 0;
        for (int i = 1; i < arraySize; ++i) {
            if (!(this.yValues[maxIndex] < this.yValues[i])) continue;
            maxIndex = i;
        }
        return maxIndex;
    }

    protected int determineLow(int arraySize) {
        int minIndex = 0;
        for (int i = 1; i < arraySize; ++i) {
            if (!(this.yValues[minIndex] > this.yValues[i])) continue;
            minIndex = i;
        }
        return minIndex;
    }

    protected String[] transformVector(Matrix input) {
        String[] output = new String[this.parameterListSize];
        for (int i = 0; i < this.parameterListSize; ++i) {
            output[i] = this.coded2param(input.get(i, 0), this.parameterLogbase[i]);
        }
        return output;
    }

    protected Matrix determineCentroid(int pointToIgnore) {
        Matrix centroid = new Matrix(this.parameterListSize, 1);
        for (int i = 0; i <= this.parameterListSize; ++i) {
            centroid = centroid.plus(this.operationMatrix.getMatrix(0, this.parameterListSize - 1, i, i));
        }
        centroid = centroid.minus(this.operationMatrix.getMatrix(0, this.parameterListSize - 1, pointToIgnore, pointToIgnore));
        centroid = centroid.times((double)(1 / this.parameterListSize));
        return centroid;
    }

    public boolean parameterIsInRange(int index) {
        double value = this.coded2param4RangeVerification(this.parameterValues[index], this.parameterLogbase[index]);
        double min = this.parameterRange[index].parameterLowerBound;
        double max = this.parameterRange[index].parameterUpperBound;
        return value >= min && value <= max;
    }

    public double getRandomValueWithinRange(int index) {
        double min = this.parameterRange[index].parameterLowerBound;
        double max = this.parameterRange[index].parameterUpperBound;
        return this.param2coded4RangeVerification(RandomGenerator.getGlobalRandomGenerator().nextDoubleInRange(Math.max(min, -10.0), Math.min(10.0, max)), this.parameterLogbase[index]);
    }

    public boolean vectorIsInRange(Matrix input) {
        boolean inRange = true;
        double parameterValue = 0.0;
        for (int i = 0; i < this.parameterListSize; ++i) {
            double min = this.parameterRange[i].parameterLowerBound;
            double max = this.parameterRange[i].parameterUpperBound;
            parameterValue = this.coded2param4RangeVerification(input.get(i, 0), this.parameterLogbase[i]);
            boolean bl = inRange = inRange && parameterValue >= min && parameterValue <= max;
            if (inRange) continue;
            LogService.logMessage("parameter " + i + " exceeds Range: " + parameterValue, 4);
        }
        return inRange;
    }

    public Matrix getRandomVectorWithinRange() {
        Matrix output = new Matrix(this.parameterListSize, 1);
        for (int i = 0; i < this.parameterListSize; ++i) {
            double min = this.parameterRange[i].parameterLowerBound;
            double max = this.parameterRange[i].parameterUpperBound;
            output.set(i, 0, this.param2coded4RangeVerification(RandomGenerator.getGlobalRandomGenerator().nextDoubleInRange(Math.max(min, -10.0), Math.min(10.0, max)), this.parameterLogbase[i]));
        }
        return output;
    }

    protected class parameterRange {
        protected String parameterName;
        protected double parameterLowerBound;
        protected double parameterUpperBound;

        protected parameterRange(String name, double min, double max) {
            this.parameterName = name;
            this.parameterLowerBound = min;
            this.parameterUpperBound = max;
        }
    }
}

