/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.List;

public class IteratingOperatorChain
extends OperatorChain {
    public IteratingOperatorChain(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        int start = this.getParameterAsInt("start");
        int end = this.getParameterAsInt("end");
        for (int i = start; i <= end; ++i) {
            super.apply();
        }
        return new IOObject[0];
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            input = this.getOperator(i).checkIO(input);
        }
        return this.getAllOutputClasses(input);
    }

    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public Class[] getOutputClasses() {
        return new Class[0];
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public int getNumberOfSteps() {
        int start = this.getParameterAsInt("start");
        int end = this.getParameterAsInt("end");
        return (end - start) * this.getNumberOfChildrensSteps() + 1;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("start", "The start value for the iteration", 0, Integer.MAX_VALUE, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("end", "The end value for the iteration", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

