/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.weka;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.weka.WekaClassifier;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaLearnerCapabilities;
import edu.udo.cs.yale.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.OptionHandler;

public class GenericWekaLearner
extends AbstractLearner {
    public static final String[] WEKA_CLASSIFIERS = WekaTools.getWekaClasses(class$weka$classifiers$Classifier == null ? (class$weka$classifiers$Classifier = GenericWekaLearner.class$("weka.classifiers.Classifier")) : class$weka$classifiers$Classifier, ".meta.", false);
    private List wekaParameters = new LinkedList();
    static /* synthetic */ Class class$weka$classifiers$Classifier;

    public GenericWekaLearner(OperatorDescription description) {
        super(description);
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Classifier classifier = this.getWekaClassifier(WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        LogService.logMessage(this.getName() + ": Converting to Weka instances.", 0);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "TempInstances", exampleSet.getLabel(), true);
        try {
            LogService.logMessage(this.getName() + ": Building Weka classifier.", 0);
            classifier.buildClassifier(instances);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, new Object[]{this.getOperatorClassName(), e.getMessage()});
        }
        return new WekaClassifier(exampleSet.getLabel(), classifier);
    }

    private Classifier getWekaClassifier(String[] parameters) throws OperatorException {
        String classifierName = this.getWekaClassPath();
        Classifier classifier = null;
        try {
            classifier = Classifier.forName((String)classifierName, (String[])parameters);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{classifierName, e});
        }
        return classifier;
    }

    public String getWekaClassPath() {
        for (int i = 0; i < WEKA_CLASSIFIERS.length; ++i) {
            if (!WEKA_CLASSIFIERS[i].endsWith(this.getOperatorClassName())) continue;
            return WEKA_CLASSIFIERS[i];
        }
        return null;
    }

    public List getWekaParameterList() {
        return this.wekaParameters;
    }

    public boolean supportsCapability(LearnerCapability capability) {
        Classifier classifier;
        try {
            classifier = this.getWekaClassifier(WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        }
        catch (OperatorException e) {
            return false;
        }
        return WekaLearnerCapabilities.supportsCapability(classifier, capability);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        Classifier classifier = null;
        try {
            classifier = this.getWekaClassifier(null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka classifier " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList();
        if (classifier != null && classifier instanceof OptionHandler) {
            WekaTools.addParameterTypes((OptionHandler)classifier, types, this.wekaParameters);
        }
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

