/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.meta.SDEnsemble;
import edu.udo.cs.yale.operator.learner.meta.SDReweightMeasures;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.LogService;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class SDRulesetInduction
extends OperatorChain {
    public static final String NUM_OF_ITERATIONS = "iterations";
    public static final String INTERNAL_BOOTSTRAP = "ratio_internal_bootstrap";
    public static final String MODEL_FILE = "model_file";
    public static final String ROC_FILTER = "ROC_convex_hull_filter";
    public static final String REWEIGHT = "additive_reweight";
    public static final String GAMMA = "gamma";
    public static final String TIMES_COVERED = "TIMES_COVERED_SPECIAL_ATTRIB";
    public static final double MIN_ADVANTAGE = 0.001;
    private double performance = 0.0;
    private int currentIteration;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$learner$Model;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public SDRulesetInduction(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The performance."){

            public double getValue() {
                return SDRulesetInduction.this.performance;
            }
        });
        this.addValue(new Value("iteration", "The current iteration."){

            public double getValue() {
                return SDRulesetInduction.this.currentIteration;
            }
        });
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        Class[] output;
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = SDRulesetInduction.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model, output = this.getOperator(0).checkIO(input))) {
            throw new IllegalInputException(this, this.getOperator(0), class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = SDRulesetInduction.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model);
        }
        return this.getDeliveredOutputClasses();
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(MODEL_FILE, "If this parameter is set, the model is written to a file.", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(INTERNAL_BOOTSTRAP, "Fraction of examples used for training (internal bootstrapping). If activated (value < 1) only the rest is used to estimate the biases.", 0.0, 1.0, 0.7));
        types.add(new ParameterTypeInt(NUM_OF_ITERATIONS, "The maximum number of iterations.", 1, Integer.MAX_VALUE, 10));
        types.add(new ParameterTypeBoolean(ROC_FILTER, "A parameter whether to discard all rules not lying on the convex hull in ROC space.", true));
        types.add(new ParameterTypeBoolean(REWEIGHT, "If enabled then resampling is done by additive reweighting, otherwise by multiplicative reweighting.", true));
        types.add(new ParameterTypeDouble(GAMMA, "Factor used for multiplicative reweighting. Has no effect in case of additive reweighting.", 0.0, 1.0, 0.9));
        return types;
    }

    public int getMaxNumberOfInnerOperators() {
        return 1;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getNumberOfSteps() {
        return 1;
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = SDRulesetInduction.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = SDRulesetInduction.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model};
    }

    public static int getPosIndex(Attribute label) {
        return label.getPositiveIndex() - 0;
    }

    private double[] prepareWeights(ExampleSet exampleSet) throws OperatorException {
        Attribute weightAttr = exampleSet.createWeightAttribute();
        Attribute timesCoveredAttrib = null;
        boolean additive = this.getParameterAsBoolean(REWEIGHT);
        if (additive && (timesCoveredAttrib = exampleSet.getAttribute(TIMES_COVERED)) == null) {
            timesCoveredAttrib = exampleSet.createSpecialAttribute(TIMES_COVERED, 3);
            exampleSet.getExampleTable().addAttribute(timesCoveredAttrib);
        }
        ExampleReader exRead = exampleSet.getExampleReader();
        int numPos = 0;
        int positiveClass = SDRulesetInduction.getPosIndex(exampleSet.getLabel());
        int negativeClass = 1 - positiveClass;
        while (exRead.hasNext()) {
            if (exRead.next().getLabel() - 0.0 != (double)positiveClass) continue;
            ++numPos;
        }
        double[] classPriors = new double[2];
        classPriors[positiveClass] = (double)numPos / (double)exampleSet.getSize();
        classPriors[negativeClass] = 1.0 - classPriors[positiveClass];
        double posWeight = 0.5 / classPriors[positiveClass];
        double negWeight = 0.5 / classPriors[negativeClass];
        exRead = exampleSet.getExampleReader();
        while (exRead.hasNext()) {
            Example example = exRead.next();
            double w = example.getLabel() == (double)positiveClass ? posWeight : negWeight;
            example.setValue(weightAttr, w);
            if (!additive) continue;
            example.setValue(timesCoveredAttrib, 0.0);
        }
        return classPriors;
    }

    private Model trainModel(ExampleSet exampleSet) throws OperatorException {
        IOContainer result = this.getOperator(0).apply(new IOContainer(new IOObject[]{exampleSet}));
        Model model = (Model)result.remove(class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = SDRulesetInduction.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model);
        model.createPredictedLabel(exampleSet);
        model.apply(exampleSet);
        return model;
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = SDRulesetInduction.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        if (exampleSet.getLabel() == null) {
            throw new UserError(this, 105);
        }
        double[] classPriors = this.prepareWeights(exampleSet);
        SDEnsemble model = this.trainRuleset(exampleSet, classPriors);
        String modelFile = this.getParameterAsString(MODEL_FILE);
        try {
            if (modelFile != null) {
                model.writeModel(this.getExperiment().resolveFileName(modelFile));
            }
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 303, new Object[]{modelFile, e.getMessage()});
        }
        return new IOObject[]{model};
    }

    private SDEnsemble trainRuleset(ExampleSet trainingSet, double[] classPriors) throws OperatorException {
        Vector<Object[]> modelInfo = new Vector<Object[]>();
        double splitRatio = this.getParameterAsDouble(INTERNAL_BOOTSTRAP);
        boolean bootstrap = splitRatio > 0.0 && splitRatio < 1.0;
        LogService.logMessage(bootstrap ? "Bootstrapping enabled." : "Bootstrapping disabled.", 2);
        int iterations = this.getParameterAsInt(NUM_OF_ITERATIONS);
        boolean roc_filter = this.getParameterAsBoolean(ROC_FILTER);
        LinkedList<double[]> rocCurve = null;
        if (roc_filter) {
            rocCurve = new LinkedList<double[]>();
            rocCurve.add(new double[]{0.0, 0.0});
            rocCurve.add(new double[]{1.0, 1.0});
        }
        for (int i = 0; i < iterations; ++i) {
            this.currentIteration = i;
            int size = trainingSet.getSize();
            ExampleSet splittedSet = trainingSet;
            if (bootstrap) {
                splittedSet = new SplittedExampleSet(trainingSet, splitRatio);
                ((SplittedExampleSet)splittedSet).selectSingleSubset(0);
            }
            Model model = this.trainModel(splittedSet);
            if (bootstrap) {
                ((SplittedExampleSet)splittedSet).selectSingleSubset(1);
                model.apply(trainingSet);
            }
            SDReweightMeasures wp = new SDReweightMeasures(splittedSet);
            boolean additive = this.getParameterAsBoolean(REWEIGHT);
            wp.setAdditive(additive);
            if (!additive) {
                wp.setGamma(this.getParameterAsDouble(GAMMA));
            }
            this.debugMessage(wp);
            double[][] modelWeightMatrix = new double[2][2];
            double tpr = 0.0;
            double fpr = 0.0;
            boolean defaultRule = false;
            int[][] predClasses = new int[][]{wp.getCoveredExamplesNumForPred(0), wp.getCoveredExamplesNumForPred(1)};
            int[] rowTotals = new int[]{predClasses[0][0] + predClasses[0][1], predClasses[1][0] + predClasses[1][1]};
            int total = rowTotals[0] + rowTotals[1];
            double cov0 = (double)rowTotals[0] / (double)total;
            double cov1 = (double)rowTotals[1] / (double)total;
            double prior0 = ((double)predClasses[0][0] + (double)predClasses[1][0]) / (double)total;
            double prior1 = ((double)predClasses[0][1] + (double)predClasses[1][1]) / (double)total;
            double bias0 = Math.abs((double)predClasses[0][0] / (double)rowTotals[0] - prior0);
            double bias1 = Math.abs((double)predClasses[1][0] / (double)rowTotals[1] - prior0);
            int subset = Double.isNaN(bias1) || cov0 * bias0 >= cov1 * bias1 ? 0 : 1;
            modelWeightMatrix[subset][0] = (double)predClasses[subset][0] / (double)rowTotals[subset];
            modelWeightMatrix[subset][1] = (double)predClasses[subset][1] / (double)rowTotals[subset];
            double ratio0 = (double)predClasses[subset][0] / (double)total / prior0;
            double ratio1 = (double)predClasses[subset][1] / (double)total / prior1;
            wp.reweightExamples(trainingSet, ratio0 > ratio1 ? 0 : 1, subset);
            if (roc_filter) {
                tpr = Math.max(ratio0, ratio1);
                fpr = Math.min(ratio0, ratio1);
            }
            boolean bl = defaultRule = cov0 == 0.0 || cov1 == 0.0;
            if (defaultRule || roc_filter && !this.isOnConvexHull(rocCurve, tpr, fpr)) continue;
            modelInfo.add(new Object[]{model, modelWeightMatrix});
        }
        if (roc_filter) {
            StringBuffer message = new StringBuffer("The convex hull in ROC space contains the following points (TPr/FPr):\n");
            Iterator it = rocCurve.iterator();
            while (it.hasNext()) {
                double[] tpfp = (double[])it.next();
                message.append("(" + tpfp[0] + ", " + tpfp[1] + ") ");
            }
            System.out.println(message);
        }
        short combinationMethod = this.getParameterAsBoolean(REWEIGHT) ? (short)1 : 2;
        return new SDEnsemble(trainingSet.getLabel(), modelInfo, classPriors, combinationMethod);
    }

    private void debugMessage(SDReweightMeasures wp) {
        String message = "\nModel learned - training performance of rule:\nTPR: " + wp.getProbability(0, 0) + " FPR: " + wp.getProbability(1, 0) + " | Positively predicted: " + (wp.getProbability(1, 0) + wp.getProbability(0, 0)) + "\nFNR: " + wp.getProbability(0, 1) + " TNR: " + wp.getProbability(1, 1) + " | Negatively predicted: " + (wp.getProbability(0, 1) + wp.getProbability(1, 1)) + "\nPositively labelled: " + (wp.getProbability(0, 0) + wp.getProbability(0, 1)) + "\nNegatively labelled: " + (wp.getProbability(1, 0) + wp.getProbability(1, 1));
        LogService.logMessage(message, 2);
    }

    private boolean isOnConvexHull(LinkedList rocCurve, double tpr, double fpr) {
        double newSlope;
        double[] current;
        if (tpr <= 0.0 || tpr > 1.0 || fpr < 0.0 || fpr >= 1.0) {
            return false;
        }
        ListIterator iter = rocCurve.listIterator();
        double slope = Double.POSITIVE_INFINITY;
        boolean fprGreater = true;
        while (fprGreater) {
            current = (double[])iter.next();
            boolean bl = fprGreater = fpr > current[1];
            if (fprGreater) {
                newSlope = (tpr - current[0]) / (fpr - current[1]);
                if (newSlope >= slope) {
                    iter.remove();
                    continue;
                }
                slope = newSlope;
                double finalSlope = (1.0 - current[0]) / (1.0 - current[1]);
                if (!(slope <= finalSlope)) continue;
                return false;
            }
            if (fpr == current[1]) {
                if (tpr > current[0]) {
                    rocCurve.set(iter.previousIndex(), new double[]{tpr, fpr});
                    continue;
                }
                return false;
            }
            double nextSlope = (current[0] - tpr) / (current[1] - fpr);
            if (slope > nextSlope) {
                rocCurve.add(iter.previousIndex(), new double[]{tpr, fpr});
                continue;
            }
            return false;
        }
        slope = (1.0 - tpr) / (1.0 - fpr);
        iter = rocCurve.listIterator(rocCurve.size());
        while (iter.hasPrevious()) {
            current = (double[])iter.previous();
            if (current[1] <= fpr) {
                return true;
            }
            newSlope = (current[0] - tpr) / (current[1] - fpr);
            if (current[1] < 1.0 && newSlope <= slope) {
                iter.remove();
                continue;
            }
            slope = newSlope;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

